/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public class AbsoluteTime
extends HighResolutionTime {
    public AbsoluteTime() {
        this(0L, 0);
    }

    @SCJAllowed
    public AbsoluteTime(AbsoluteTime absoluteTime) {
        this(AbsoluteTime.getMillisNonNull(absoluteTime), absoluteTime._nanoseconds);
    }

    @SCJAllowed
    public AbsoluteTime(long l, int n) {
        super(l, n, null);
    }

    public AbsoluteTime(long l, int n, Clock clock) {
        super(l, n, clock);
    }

    AbsoluteTime(long l) {
        super(l / 1000000L, (int)(l % 1000000L), Clock.rtc);
    }

    @SCJAllowed
    public AbsoluteTime(Clock clock) {
        this(0L, 0, clock);
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime add(long l, int n) {
        return this.add(l, n, null);
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime add(RelativeTime relativeTime) {
        if (relativeTime == null || relativeTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return this.add(relativeTime._milliseconds, relativeTime._nanoseconds, null);
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime add(RelativeTime relativeTime, AbsoluteTime absoluteTime) {
        if (relativeTime == null || relativeTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return this.add(relativeTime._milliseconds, relativeTime._nanoseconds, absoluteTime);
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime add(long l, int n, AbsoluteTime absoluteTime) {
        return (AbsoluteTime)super.add(l, n, absoluteTime == null ? new AbsoluteTime(0L, 0, this._clock) : absoluteTime);
    }

    @SCJAllowed
    @SCJRestricted
    public RelativeTime subtract(AbsoluteTime absoluteTime) {
        if (absoluteTime == null || absoluteTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return (RelativeTime)this.add(-absoluteTime._milliseconds, -absoluteTime._nanoseconds, new RelativeTime(0L, 0, this._clock));
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime subtract(RelativeTime relativeTime) {
        if (relativeTime == null || relativeTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return this.add(-relativeTime._milliseconds, -relativeTime._nanoseconds, new AbsoluteTime(0L, 0, this._clock));
    }

    @SCJAllowed
    @SCJRestricted
    public RelativeTime subtract(AbsoluteTime absoluteTime, RelativeTime relativeTime) {
        if (absoluteTime == null || absoluteTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        if (relativeTime == null) {
            relativeTime = new RelativeTime(0L, 0, this._clock);
        }
        return (RelativeTime)this.add(-absoluteTime._milliseconds, -absoluteTime._nanoseconds, relativeTime);
    }

    @SCJAllowed
    @SCJRestricted
    public AbsoluteTime subtract(RelativeTime relativeTime, AbsoluteTime absoluteTime) {
        return null;
    }

    public RelativeTime relative(Clock clock) {
        if (clock == null) {
            clock = Clock.rtc;
        }
        return clock.getTime().subtract(this);
    }

    public RelativeTime relative(Clock clock, RelativeTime relativeTime) {
        if (clock == null) {
            clock = Clock.rtc;
        }
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        return clock.getTime().subtract(this, relativeTime);
    }

    private static long getMillisNonNull(AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            throw new IllegalArgumentException("null parameter");
        }
        return absoluteTime._milliseconds;
    }
}

