/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

public class Terminal {
    private static Terminal single = new Terminal();

    private Terminal() {
    }

    public static Terminal getTerminal() {
        return single;
    }

    public void write(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                this.write((byte)(c & 0x7F));
                continue;
            }
            if (c < '\u0800') {
                this.write((byte)(0xC0 | c >>> 6));
                this.write((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (c >= '\u1000') continue;
            this.write((byte)(0xE0 | c >>> 12));
            this.write((byte)(0x80 | c >>> 6 & 0x3F));
            this.write((byte)(0x80 | c & 0x3F));
        }
    }

    public void writeln(CharSequence charSequence) {
        this.write(charSequence);
        this.writeln();
    }

    public void writeln() {
        this.write("\r\n");
    }

    private void write(byte by) {
        System.out.write(by);
    }
}

