/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.LTMemory;
import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionManager;

public class PrivateMemory
extends LTMemory
implements ManagedMemory {
    private MissionManager _manager;
    private ManagedMemory _parent;
    private volatile boolean _occupied;

    public PrivateMemory(long l) {
        super(l);
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (!(memoryArea instanceof ManagedMemory)) {
            throw new Error("Private memory cannot be created in " + memoryArea);
        }
        this._parent = (ManagedMemory)memoryArea;
        this._manager = this._parent.getManager();
    }

    public MissionManager getManager() {
        return this._manager;
    }

    public void enter(Runnable runnable) {
        if (this._parent != RealtimeThread.getCurrentMemoryArea()) {
            throw new Error("Attempt to enter private memory " + this + " from the memory area other than its parent");
        }
        if (this._occupied) {
            throw new Error("Attempt to enter the occupied private memory: " + this);
        }
        this._occupied = true;
        super.enter(runnable);
        this._occupied = false;
    }
}

