/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionManager;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.Safelet;
import javax.safetycritical.Services;
import javax.safetycritical.SingleMissionSequencer;
import javax.safetycritical.StorageConfigurationParameters;

public abstract class CyclicExecutive
extends Mission
implements Safelet {
    private MissionSequencer _sequencer;
    private static RelativeTime _ZERO = new RelativeTime(0L, 0);

    public CyclicExecutive(StorageConfigurationParameters storageConfigurationParameters) {
        int n = PriorityScheduler.instance().getNormPriority();
        this._sequencer = new SingleMissionSequencer(new PriorityParameters(n), storageConfigurationParameters, this);
    }

    public abstract CyclicSchedule getSchedule(PeriodicEventHandler[] var1);

    public MissionSequencer getSequencer() {
        return this._sequencer;
    }

    protected void exec(MissionManager missionManager) {
        PeriodicEventHandler[] periodicEventHandlerArray = new PeriodicEventHandler[missionManager._peHandlers.size()];
        int n = 0;
        Object object = missionManager._peHandlers.iterator();
        while (object.hasNext()) {
            periodicEventHandlerArray[n] = (PeriodicEventHandler)((Object)object.next());
            ++n;
        }
        object = this.getSchedule(periodicEventHandlerArray);
        CyclicSchedule.Frame[] frameArray = ((CyclicSchedule)object).getFrames();
        AbsoluteTime absoluteTime = Clock.getRealtimeClock().getTime();
        RelativeTime relativeTime = new RelativeTime();
        while (this._phase == 1) {
            for (int i = 0; i < frameArray.length; ++i) {
                absoluteTime.add(frameArray[i].getDuration(), absoluteTime);
                for (int j = 0; j < frameArray[i].getHandlers().length; ++j) {
                    frameArray[i].getHandlers()[j].handleAsyncEvent();
                }
                this.waitForNextFrame(absoluteTime, relativeTime);
            }
        }
    }

    private void waitForNextFrame(AbsoluteTime absoluteTime, RelativeTime relativeTime) {
        int n = absoluteTime.relative(Clock.getRealtimeClock(), relativeTime).compareTo((HighResolutionTime)_ZERO);
        if (n > 0) {
            Services.sleepNonInterruptable(relativeTime);
        } else if (n < 0) {
            // empty if block
        }
    }
}

