/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import com.fiji.fivm.r1.NoScopeChecks;
import javax.realtime.LTMemory;
import javax.realtime.RealtimeThread;
import javax.realtime.SizeEstimator;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.MissionManager;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public abstract class ManagedMemory
extends LTMemory {
    private MissionManager _manager;
    private ManagedSchedulable _owner;
    static ManagedMemory _current;
    private ManagedMemory _child = null;

    public ManagedMemory(long l) {
        super(l);
    }

    public ManagedMemory(SizeEstimator sizeEstimator) {
        super(sizeEstimator);
    }

    @SCJAllowed
    public MissionManager getManager() {
        return this._manager;
    }

    @SCJAllowed
    public static ManagedMemory getCurrentManagedMemory() throws IllegalStateException {
        return (ManagedMemory)RealtimeThread.getCurrentMemoryArea();
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public void enter(Runnable runnable) {
        super.enter(runnable);
        this.destroyChild();
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    protected void destroyChild() {
        if (this._child != null) {
            this._child = null;
        }
    }

    @SCJAllowed
    @NoScopeChecks
    public void enterPrivateMemory(long l, Runnable runnable) {
        if (l < 0L) {
            throw new IllegalArgumentException("Mission memory size must be non-negative");
        }
        if (this._child == null) {
            this._child = new PrivateMemory(l);
            this._child.setOwner(this._owner);
        } else {
            this._child.setSize(l);
        }
        this._child.enter(runnable);
    }

    @SCJAllowed
    public ManagedSchedulable getOwner() {
        return this._owner;
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public void setOwner(ManagedSchedulable managedSchedulable) {
        this._owner = managedSchedulable;
    }
}

