/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import edu.purdue.scj.VMSupport;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public final class SizeEstimator {
    private long size = 0L;

    @SCJAllowed
    public SizeEstimator() {
    }

    @SCJAllowed
    @SCJRestricted
    public long getEstimate() {
        return this.size;
    }

    @SCJAllowed
    @SCJRestricted
    public void reserve(Class clazz, int n) {
        if (clazz != null) {
            this.size += (long)n * VMSupport.sizeOf(clazz);
        }
    }

    @SCJAllowed
    @SCJRestricted
    public void reserve(SizeEstimator sizeEstimator) {
        this.reserve(sizeEstimator, 1);
    }

    @SCJAllowed
    @SCJRestricted
    public void reserve(SizeEstimator sizeEstimator, int n) {
        if (sizeEstimator != null) {
            this.size += (long)n * sizeEstimator.size;
        }
    }

    @SCJAllowed
    @SCJRestricted
    public void reserveArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative length");
        }
        this.size += VMSupport.sizeOfReferenceArray(n);
    }

    @SCJAllowed
    @SCJRestricted
    public void reserveArray(int n, Class clazz) {
        if (n < 0) {
            throw new IllegalArgumentException("negative length");
        }
        if (clazz == null || !clazz.isPrimitive()) {
            throw new IllegalArgumentException("type is not a primitive type");
        }
        this.size += VMSupport.sizeOfPrimitiveArray(n, clazz);
    }
}

