/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.fiji.fivm.r1.NoScopeChecks;
import edu.purdue.scj.BackingStoreID;
import edu.purdue.scj.VMSupport;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.ScopedMemory;

class ScopeStack {
    static final int _INCREASE = 8;
    static final long _BASE_SIZE = VMSupport.sizeOf(ScopeStack.class);
    int _size;
    int _capacity;
    long _memSize;
    int _activePointer;
    Thread _owner;
    BackingStoreID[] _stack;

    ScopeStack(Thread thread) {
        this._size = 0;
        this._activePointer = 0;
        this._capacity = 8;
        this._memSize = ScopeStack.constructionSizeOf(8);
        this.allocBackingStoreArray();
        ImmortalMemory immortalMemory = ImmortalMemory.instance();
        this.push(immortalMemory);
    }

    ScopeStack(Thread thread, ScopeStack scopeStack) {
        this._size = scopeStack._activePointer;
        this._activePointer = scopeStack._activePointer;
        this._capacity = scopeStack._capacity;
        this._memSize = scopeStack._memSize;
        this.allocBackingStoreArray();
        for (int i = 0; i < this._size; ++i) {
            this.setAt(scopeStack.getAt(i), i);
        }
    }

    MemoryArea areaAt(int n, boolean bl) {
        int n2;
        int n3 = n2 = bl ? this._activePointer : this._size;
        if (n >= 0 && n < n2) {
            return MemoryArea.getMemoryAreaObject(this.getAt(n));
        }
        return null;
    }

    MemoryArea getCurrentArea() {
        return MemoryArea.getMemoryAreaObject(this.getAt(this._activePointer - 1));
    }

    int getDepth(boolean bl) {
        return bl ? this._activePointer : this._size;
    }

    int getIndex(MemoryArea memoryArea, boolean bl) {
        int n = bl ? this._activePointer : this._size;
        for (int i = n - 1; i >= 0; --i) {
            if (this.getAt(i) != memoryArea.get_scopeID()) continue;
            return i;
        }
        return -1;
    }

    ScopedMemory getTopScopedMemory(boolean bl) {
        int n = bl ? this._activePointer : this._size;
        for (int i = n - 1; i >= 0; --i) {
            if (this.getAt(i) == ImmortalMemory.instance().get_scopeID()) continue;
            return (ScopedMemory)MemoryArea.getMemoryAreaObject(this.getAt(i));
        }
        return null;
    }

    void pop() {
        if (this._size == 0) {
            throw new Error("attempt to pop empty stack");
        }
        if (this._size != this._activePointer) {
            throw new Error("attempt to pop a scope when it is inactive");
        }
        this.setAt(null, this._size--);
        --this._activePointer;
    }

    void push(MemoryArea memoryArea) {
        if (this._size == this._capacity) {
            this.grow();
        }
        if (this._size != this._activePointer) {
            // empty if block
        }
        try {
            this.setAt(memoryArea.get_scopeID(), this._size++);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ++this._activePointer;
    }

    void setActivePointer(int n) {
        if (n < 0 || n > this._size) {
            throw new Error("Invalid active pointer: " + n);
        }
        this._activePointer = n;
    }

    void dump() {
        for (int i = this._size - 1; i >= 0; --i) {
        }
    }

    void free() {
    }

    @NoScopeChecks
    BackingStoreID[] get_stack() {
        return this._stack;
    }

    @NoScopeChecks
    void set_stack(BackingStoreID[] backingStoreIDArray) {
        this._stack = backingStoreIDArray;
    }

    @NoScopeChecks
    void setAt(BackingStoreID backingStoreID, int n) {
        this._stack[n] = backingStoreID;
    }

    @NoScopeChecks
    BackingStoreID getAt(int n) {
        return this._stack[n];
    }

    private static long constructionSizeOf(int n) {
        return VMSupport.sizeOfReferenceArray(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocBackingStoreArray() {
        this.set_stack(new BackingStoreID[this._capacity]);
    }

    private void grow() {
        throw new UnsupportedOperationException("Scope stack grow unimplemented");
    }
}

