/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import edu.purdue.scj.BackingStoreID;
import edu.purdue.scj.VMSupport;
import edu.purdue.scj.utils.Utils;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.SchedulingParameters;
import javax.realtime.ScopeStack;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.LEVEL_1)
public class RealtimeThread
extends Thread
implements Schedulable {
    SchedulingParameters _sParams;
    ReleaseParameters _rParams;
    final MemoryArea initArea;
    final int _initAreaIndex;
    private ScopeStack _scopeStack;
    private Runnable _wrapper = new Runnable(){

        public void run() {
            RealtimeThread.super.run();
        }
    };

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public RealtimeThread() {
        this.initArea = ImmortalMemory.instance();
        this._scopeStack = new ScopeStack(this);
        this._initAreaIndex = 0;
        VMSupport.setThreadPriority(this, VMSupport.getMinRTPriority());
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public RealtimeThread(long l) {
        this.initArea = ImmortalMemory.instance();
        this._scopeStack = new ScopeStack(this);
        this._initAreaIndex = 0;
        VMSupport.setThreadPriority(this, VMSupport.getMinRTPriority());
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public RealtimeThread(SchedulingParameters schedulingParameters, MemoryArea memoryArea) {
        this(schedulingParameters, null, null, memoryArea, null, null);
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public RealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable) {
        super(runnable);
        this._scopeStack = new ScopeStack(this, RealtimeThread.currentRealtimeThread().getScopeStack());
        if (memoryArea == null) {
            Utils.panic("null init area not allowed");
        }
        this.initArea = memoryArea;
        this._initAreaIndex = this._scopeStack.getDepth(true);
        this._scopeStack.dump();
        VMSupport.setThreadPriority(this, VMSupport.getMinRTPriority());
    }

    @SCJAllowed(value=Level.LEVEL_2)
    public ReleaseParameters getReleaseParameters() {
        return this._rParams;
    }

    @SCJAllowed(value=Level.LEVEL_2)
    public SchedulingParameters getSchedulingParameters() {
        return this._sParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        BackingStoreID backingStoreID = VMSupport.areaOf(this);
        BackingStoreID backingStoreID2 = VMSupport.setCurrentArea(backingStoreID);
        try {
            super.start();
        }
        finally {
            VMSupport.setCurrentArea(backingStoreID2);
        }
    }

    public void run() {
        this.initArea.preScopeEnter(this);
        RealtimeThread.currentRealtimeThread().getScopeStack().push(this.initArea);
        this.initArea.enter(this._wrapper);
        RealtimeThread.currentRealtimeThread().getScopeStack().pop();
        this.initArea.postScopeEnter();
    }

    @SCJAllowed(value=Level.LEVEL_2)
    public static RealtimeThread currentRealtimeThread() {
        return (RealtimeThread)Thread.currentThread();
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public static MemoryArea getCurrentMemoryArea() {
        return MemoryArea.getMemoryAreaObject(VMSupport.getCurrentArea());
    }

    public static int getMemoryAreaStackDepth() {
        return RealtimeThread.currentRealtimeThread().getScopeStack().getDepth(true);
    }

    public static MemoryArea getOuterMemoryArea(int n) {
        return RealtimeThread.currentRealtimeThread().getScopeStack().areaAt(n, true);
    }

    ScopeStack getScopeStack() {
        return this._scopeStack;
    }
}

