/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import edu.purdue.scj.VMSupport;
import javax.realtime.PhysicalMemoryName;
import javax.realtime.RawMemoryAccess;
import javax.realtime.RawRealAccess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.LEVEL_0)
public class RawMemoryFloatAccess
extends RawMemoryAccess
implements RawRealAccess {
    private static final int LENGTH_OF_FLOAT = 4;
    private static final int LENGTH_OF_DOUBLE = 8;

    @SCJAllowed(value=Level.LEVEL_0)
    public RawMemoryFloatAccess(PhysicalMemoryName physicalMemoryName, long l) {
        super(physicalMemoryName, l);
    }

    public RawMemoryFloatAccess(PhysicalMemoryName physicalMemoryName, long l, long l2) {
        super(physicalMemoryName, l, l2);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public double getDouble(long l) {
        return VMSupport.getDouble(this.checkOffset(l, 8L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getDoubles(long l, double[] dArray, int n, int n2) {
        this.checkOffset(l, n2 * 8);
        int n3 = 0;
        while (n3 < n2) {
            dArray[n + n3] = this.getDouble(l);
            ++n3;
            l += 8L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public float getFloat(long l) {
        return VMSupport.getFloatAtomic(this.checkOffset(l, 4L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getFloats(long l, float[] fArray, int n, int n2) {
        this.checkOffset(l, n2 * 4);
        int n3 = 0;
        while (n3 < n2) {
            fArray[n + n3] = this.getFloat(l);
            ++n3;
            l += 4L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setDouble(long l, double d) {
        VMSupport.setDouble(this.checkOffset(l, 8L), d);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setDoubles(long l, double[] dArray, int n, int n2) {
        this.checkOffset(l, n2 * 8);
        int n3 = 0;
        while (n3 < n2) {
            this.setDouble(l, dArray[n + n3]);
            ++n3;
            l += 8L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setFloat(long l, float f) {
        VMSupport.setFloatAtomic(this.checkOffset(l, 4L), f);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setFloats(long l, float[] fArray, int n, int n2) {
        this.checkOffset(l, n2 * 4);
        int n3 = 0;
        while (n3 < n2) {
            this.setFloat(l, fArray[n + n3]);
            ++n3;
            l += 4L;
        }
    }
}

