/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public class Terminal {
    private static Terminal single = new Terminal();

    private Terminal() {
    }

    @SCJAllowed
    public static Terminal getTerminal() {
        return single;
    }

    @SCJAllowed
    public void write(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                this.write((byte)(c & 0x7F));
                continue;
            }
            if (c < '\u0800') {
                this.write((byte)(0xC0 | c >>> 6));
                this.write((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (c >= '\u1000') continue;
            this.write((byte)(0xE0 | c >>> 12));
            this.write((byte)(0x80 | c >>> 6 & 0x3F));
            this.write((byte)(0x80 | c & 0x3F));
        }
    }

    @SCJAllowed
    public void writeln(CharSequence charSequence) {
        this.write(charSequence);
        this.writeln();
    }

    @SCJAllowed
    public void writeln() {
        this.write("\r\n");
    }

    private void write(byte by) {
        System.out.write(by);
    }
}

