/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.timesys.SemHolder;
import javax.realtime.AsyncEventHandler;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryScopeException;
import javax.realtime.WaitFreeReadQueue;

public class WaitFreeWriteQueue {
    private Object[] theQueue;
    private int head = 0;
    private int tail = 0;
    private int queueSize = 0;
    private MemoryArea memArea;
    private SemHolder fullSem;
    private SemHolder emptySem;
    static /* synthetic */ Class class$java$lang$Object;

    public WaitFreeWriteQueue(int n) {
        this(n, MemoryArea.getEffImmortalMa());
    }

    public WaitFreeWriteQueue(int n, MemoryArea memoryArea) {
        if (memoryArea == null) {
            throw new IllegalArgumentException("Null area");
        }
        this.init(null, null, n, memoryArea);
    }

    public WaitFreeWriteQueue(Runnable runnable, Runnable runnable2, int n, MemoryArea memoryArea) throws IllegalArgumentException {
        this.init(runnable, runnable2, n, memoryArea);
    }

    private void init(Runnable runnable, Runnable runnable2, int n, MemoryArea memoryArea) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("maximum cannot be less than or equal to 0");
        }
        if (runnable != null && !(runnable instanceof Thread) && !(runnable instanceof AsyncEventHandler)) {
            throw new IllegalArgumentException("writer is not a Thread or Schedulable Object");
        }
        if (runnable2 != null && !(runnable2 instanceof Thread) && !(runnable2 instanceof AsyncEventHandler)) {
            throw new IllegalArgumentException("reader is not a Thread or Schedulable Object");
        }
        this.emptySem = new SemHolder(n);
        this.fullSem = new SemHolder(0);
        if (memoryArea == null) {
            if (runnable != null && runnable2 != null) {
                this.memArea = WaitFreeReadQueue.getCommonMemoryArea(runnable instanceof AsyncEventHandler ? ((AsyncEventHandler)runnable).aehImpl.handlerThread : (Thread)runnable, runnable2 instanceof AsyncEventHandler ? ((AsyncEventHandler)runnable2).aehImpl.handlerThread : (Thread)runnable2);
            }
            if (this.memArea == null) {
                this.memArea = MemoryArea.getEffImmortalMa();
            }
        } else if (memoryArea.reachableMemory()) {
            this.memArea = memoryArea;
        } else {
            throw new InaccessibleAreaException(memoryArea.toString() + " is not available for the queue memory");
        }
        this.theQueue = (Object[])this.memArea.newArray(class$java$lang$Object == null ? (class$java$lang$Object = WaitFreeWriteQueue.class$("java.lang.Object")) : class$java$lang$Object, n + 1);
        this.queueSize = n + 1;
    }

    public void clear() {
        this.tail = 0;
        this.head = 0;
        while (this.fullSem.tryDown()) {
            this.emptySem.up();
        }
    }

    public boolean isEmpty() {
        return this.fullSem.getCount() == 0;
    }

    public boolean isFull() {
        return this.emptySem.getCount() == 0;
    }

    public synchronized Object read() throws InterruptedException {
        Object object = null;
        this.fullSem.down();
        object = this.theQueue[this.head];
        this.head = (this.head + 1) % this.queueSize;
        this.emptySem.up();
        return object;
    }

    public int size() {
        if (this.head == this.tail) {
            if (this.isEmpty()) {
                return 0;
            }
            return this.queueSize;
        }
        if (this.head > this.tail) {
            return this.queueSize - (this.head - this.tail);
        }
        return this.tail - this.head;
    }

    public boolean force(Object object) throws MemoryScopeException, IllegalArgumentException {
        if (this.write(object)) {
            return false;
        }
        int n = this.tail;
        n = n == 0 ? this.queueSize - 1 : --n;
        this.theQueue[n] = object;
        return this.tail != this.head;
    }

    public boolean write(Object object) throws MemoryScopeException, IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("null object passed");
        }
        if (this.emptySem.tryDown()) {
            try {
                this.theQueue[this.tail] = object;
                this.tail = (this.tail + 1) % this.queueSize;
                this.fullSem.up();
            }
            catch (Throwable throwable) {
                this.emptySem.up();
                throw new MemoryScopeException("Caller cannot store into the memory area containing the queue");
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

