/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.Interruptible;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;

public class AsynchronouslyInterruptedException
extends InterruptedException {
    private static final long serialVersionUID = 1L;
    private static AsynchronouslyInterruptedException genericAIE = new AsynchronouslyInterruptedException();
    private RealtimeThread targetThread = null;
    private int doInterruptibleDepth = 0;
    private Object isInDoInterruptibleRunLock = new Object();
    private boolean isInDoInterruptibleRun = false;
    private boolean isEnabled = true;
    private Object enabledLock = new Object();
    private boolean hasFired = false;

    public AsynchronouslyInterruptedException() {
        if (RealtimeSystem.isSoftSubsetLExcludeAtcOn()) {
            throw new IllegalStateException("AsynchronouslyInterrupted exceptions cannot be created in soft-rt mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doInterruptible(Interruptible interruptible) {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("Current thread is not a javax.realtime.RealtimeThread");
        }
        if (interruptible == null) {
            throw new IllegalArgumentException("Current thread is not a javax.realtime.RealtimeThread");
        }
        if (this.targetThread != null) {
            return false;
        }
        this.targetThread = RealtimeThread.currentRealtimeThread();
        ++this.targetThread.doInterruptibleDepth;
        this.doInterruptibleDepth = this.targetThread.doInterruptibleDepth--;
        try {
            try {
                this.doInterruptibleRun(interruptible);
            }
            catch (AsynchronouslyInterruptedException asynchronouslyInterruptedException) {
                Object object = this.isInDoInterruptibleRunLock;
                synchronized (object) {
                    this.isInDoInterruptibleRun = false;
                }
                try {
                    interruptible.interruptAction(asynchronouslyInterruptedException);
                }
                finally {
                    this.happened(true);
                }
            }
        }
        finally {
            Object object = this.isInDoInterruptibleRunLock;
            synchronized (object) {
                this.isInDoInterruptibleRun = false;
            }
            this.enable();
            this.targetThread = null;
            this.doInterruptibleDepth = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInterruptibleRun(Interruptible interruptible) throws AsynchronouslyInterruptedException {
        this.isInDoInterruptibleRun = true;
        this.callRun(interruptible);
        Object object = this.isInDoInterruptibleRunLock;
        synchronized (object) {
            this.isInDoInterruptibleRun = false;
        }
    }

    void callRun(Interruptible interruptible) throws AsynchronouslyInterruptedException {
        interruptible.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire() {
        Object object = this.isInDoInterruptibleRunLock;
        synchronized (object) {
            if (!this.isInDoInterruptibleRun) {
                return false;
            }
            Object object2 = this.enabledLock;
            synchronized (object2) {
                if (this.isEnabled) {
                    Object object3 = this.targetThread.eeLock;
                    synchronized (object3) {
                        AsynchronouslyInterruptedException asynchronouslyInterruptedException = AsynchronouslyInterruptedException.getPendingAIE(this.targetThread);
                        if (asynchronouslyInterruptedException == null || asynchronouslyInterruptedException.doInterruptibleDepth > this.doInterruptibleDepth) {
                            this.postAIE(this.targetThread);
                        } else {
                            AsynchronouslyInterruptedException.interruptWait0(this.targetThread);
                        }
                    }
                } else {
                    this.hasFired = true;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enable() {
        if (Thread.currentThread() != this.targetThread) {
            return false;
        }
        Object object = this.enabledLock;
        synchronized (object) {
            if (this.isEnabled) {
                return false;
            }
            this.isEnabled = true;
            if (this.hasFired) {
                this.fire();
                this.hasFired = false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disable() {
        if (Thread.currentThread() != this.targetThread) {
            return false;
        }
        Object object = this.isInDoInterruptibleRunLock;
        synchronized (object) {
            if (!this.isInDoInterruptibleRun) {
                return false;
            }
            Object object2 = this.enabledLock;
            synchronized (object2) {
                if (this.isEnabled) {
                    this.isEnabled = false;
                    return true;
                }
                return false;
            }
        }
    }

    public boolean isEnabled() {
        if (Thread.currentThread() != this.targetThread) {
            return false;
        }
        return this.isEnabled;
    }

    public static AsynchronouslyInterruptedException getGeneric() {
        if (RealtimeSystem.isSoftSubsetLExcludeAtcOn()) {
            throw new IllegalStateException("AsynchronouslyInterruptedExceptions are not supported in soft-rt.");
        }
        return genericAIE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean happened(boolean bl) {
        AsynchronouslyInterruptedException asynchronouslyInterruptedException = null;
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("Current thread not A javax.realtime.RealtimeThread");
        }
        Object object = RealtimeThread.currentRealtimeThread().eeLock;
        synchronized (object) {
            asynchronouslyInterruptedException = AsynchronouslyInterruptedException.getPendingAIE(RealtimeThread.currentRealtimeThread());
            if (this == asynchronouslyInterruptedException) {
                AsynchronouslyInterruptedException.clearPendingAIE();
                return true;
            }
            if (!bl) {
                return false;
            }
            AsynchronouslyInterruptedException.propagate();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("Current thread not A javax.realtime.RealtimeThread");
        }
        Object object = RealtimeThread.currentRealtimeThread().eeLock;
        synchronized (object) {
            AsynchronouslyInterruptedException asynchronouslyInterruptedException = AsynchronouslyInterruptedException.getPendingAIE(RealtimeThread.currentRealtimeThread());
            if (this == asynchronouslyInterruptedException) {
                AsynchronouslyInterruptedException.clearPendingAIE();
                return true;
            }
            return false;
        }
    }

    public static void propagate() {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("current thread not A javax.realtime.RealtimeThread");
        }
        if (AsynchronouslyInterruptedException.getPendingAIE(RealtimeThread.currentRealtimeThread()) != null) {
            AsynchronouslyInterruptedException.propagate0();
        }
    }

    private static native void propagate0();

    private static AsynchronouslyInterruptedException getPendingAIE(RealtimeThread realtimeThread) {
        return AsynchronouslyInterruptedException.getPendingAIE0(realtimeThread);
    }

    private static native AsynchronouslyInterruptedException getPendingAIE0(RealtimeThread var0);

    private static void clearPendingAIE() {
        AsynchronouslyInterruptedException.clearPendingAIE0();
    }

    private static native void clearPendingAIE0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postAIE(RealtimeThread realtimeThread) {
        Object object = realtimeThread.eeLock;
        synchronized (object) {
            if (!this.postAIE0(realtimeThread)) {
                throw new IllegalThreadStateException("Inactive Thread");
            }
        }
    }

    private native boolean postAIE0(RealtimeThread var1);

    private static native void interruptWait0(RealtimeThread var0);
}

