/*
 * Decompiled with CFR 0.152.
 */
package com.timesys;

import javax.realtime.MemoryParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;

public class HighPriorityScheduler
extends Scheduler {
    private static final int RESERVE_FOR_HIGH_P_SCHED = 12;
    private static final int RESERVE_FOR_NON_JAVA = 3;
    public static final int MAX_PRIORITY = HighPriorityScheduler.getMaxRtPriority() + 12;
    public static final int MIN_PRIORITY = MAX_PRIORITY - 12;
    private String policyName = new String("High Fixed Priority Scheduler");
    private static HighPriorityScheduler singleton = new HighPriorityScheduler();

    private HighPriorityScheduler() {
        if (MAX_PRIORITY - 10 > HighPriorityScheduler.getMaxPriority0()) {
            System.err.println("Insufficient headroom for system threads.  Max supported FIFO priority is " + HighPriorityScheduler.getMaxPriority0() + ". We need " + (MAX_PRIORITY - 10));
            System.err.println("Continuing execution, but expect delays for high-priority threads.");
        }
    }

    public static HighPriorityScheduler instance() {
        return singleton;
    }

    public int getMaxPriority() {
        return MAX_PRIORITY;
    }

    public int getMinPriority() {
        return MIN_PRIORITY;
    }

    protected boolean addToFeasibility(Schedulable schedulable) {
        return true;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public boolean isFeasible() {
        return true;
    }

    public boolean removeFromFeasibility(Schedulable schedulable) {
        return true;
    }

    public void fireSchedulable(Schedulable schedulable) {
        PriorityScheduler.instance().fireSchedulable(schedulable);
    }

    public boolean setIfFeasible(Schedulable schedulable, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return true;
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return true;
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return true;
    }

    public static int getMaxRtPriority() {
        if (HighPriorityScheduler.restrictPriorities0() > HighPriorityScheduler.getMaxPriority0()) {
            return HighPriorityScheduler.getMaxPriority0() + 10 - 15;
        }
        return HighPriorityScheduler.restrictPriorities0();
    }

    private static native int getMaxPriority0();

    private static native int getMinPriority0();

    public static native int restrictPriorities0();
}

