/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.MemoryArea;
import javax.realtime.PriorityParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.SchedulingParameters;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.StorageConfigurationParameters;

public abstract class MissionSequencer
extends BoundAsyncEventHandler {
    private AsyncEvent _event = new AsyncEvent();
    private MissionMemory _missionMem = null;
    private Object _quitMonitor = new Object();
    private boolean _notified = false;
    private Mission _mission;

    public MissionSequencer(PriorityParameters priorityParameters, StorageConfigurationParameters storageConfigurationParameters) {
        super((SchedulingParameters)priorityParameters, null, null, null, null, true, null);
        this._event.addHandler((AsyncEventHandler)this);
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (memoryArea instanceof ManagedMemory) {
            ((ManagedMemory)memoryArea).getManager().addMissionSequencer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void handleAsyncEvent() {
        this._mission = this.getNextMission();
        while (this._mission != null) {
            this._missionMem = new MissionMemory(this._mission.missionMemorySize());
            this._missionMem.setSize(this._mission.missionMemorySize());
            this._missionMem.enter(this._mission);
            if (this._mission._terminateAll) break;
            this._mission = this.getNextMission();
        }
        Object object = this._quitMonitor;
        synchronized (object) {
            this._notified = true;
            this._quitMonitor.notifyAll();
        }
    }

    public synchronized void start() {
        this._event.fire();
    }

    public final void requestTermination() {
        this._mission.requestSequenceTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTermination() {
        Object object = this._quitMonitor;
        synchronized (object) {
            while (!this._notified) {
                try {
                    this._quitMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract Mission getNextMission();
}

