/**
 * @author Kun Wei, Frank Zeyda
 */
package cdx;

import javacp.util.ArrayList;
 /**
  * This class is used to pre-allocate ArrayLists  in mission memory.
  * The number of objects and the length of ArrayList are initilised in Construct.
  */

public class ArrayListFactory {
  
  /** The Array of ArrayLists  */
  private final ArrayList[] store;

  /** The index of ArrayLists */
  private int index;

  /**
   * Constructor with the number of ArrayList and the length for each ArrayList.
   * @param size      the number of ArrayLists 
   * @param capacity  the length of an ArrayList
   */
  public ArrayListFactory(int size, int capacity) {
    store = new ArrayList[size];
    for (int i = 0; i < store.length; i++) {
      store[i] = new ArrayList(capacity + 1);
    }
    index = 0;
  }

  /** 
   * Return an ArrayList from the store. The system exists if exceeding the 
   * store capacity
   * @return an ArrayList or null
   */
  public ArrayList getNewList() {
    if (index < store.length) {
      return store[index++];
    }
    else {
      Error.abort("Exceeding storage capacity in ArrayListFactory.");
      return null; // Never reached.
    }
  }

  /**Clear the content of all ArrayLists. */
  public void clear() {
    for (int i = 0; i < index; i++) {
      store[i].clear();
    }
    index = 0;
  }
}
