package cdx;

/**
 * This class acts as a contained for all factories needed to pre-allocate
 * shared objects in mission memory.
 *
 * @author Frank Zeyda
 */
public class PersistentData {
  
  /** An instance of ArrayListFactory */
  private final ArrayListFactory listFactory;
  /** An instance of MotionFactory */
  private final MotionFactory motionFactory;

  /** Constructor and initialisation of shared variables. */
  public PersistentData() {
    listFactory = new ArrayListFactory(
      Constants.NUMBER_OF_PLANES * 3,
      Constants.NUMBER_OF_PLANES);

    motionFactory = new MotionFactory(
      Constants.NUMBER_OF_PLANES * Constants.NUMBER_OF_PLANES);
  }

  /** Get the listFactory */
  public ArrayListFactory getListFactory() {
    return listFactory;
  }

  /** Get the motionFactory */
  public MotionFactory getMotionFactory() {
    return motionFactory;
  }
}
