/**
 *  This file is part of miniCDx benchmark of oSCJ.
 *
 *   miniCDx is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   miniCDx is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with miniCDx.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *   Copyright 2009, 2010
 *   @authors  Daniel Tang, Ales Plsek
 *
 *   See: http://sss.cs.purdue.edu/projects/oscj/
 */
package cdx;

/**
 *The purpose of this class is to permit printing of debug messages with
 * callsigns (byte arrays) and floating point data from a no-heap thread.
 * With standard Java ways of doing this, we get MemoryAccessError due to
 * the internal use of ThreadLocal by Sun RTS for character encoders/decoders
 * (and possibly other things). With encoders/decoders, lazy initialisation
 * leads to uncontrolled allocation w.r.t. to scope. Most likely the problem
 * is that the thread locals get allocated on the heap.
 */

public class ASCIIConverter {
 
  /** Convert byte[] to a string 
   * @param bytes The converted object
   * @return A string from bytes
   */
  public static String bytesToString(byte[] bytes) {
    char[] chars = new char[bytes.length];

    for (int i = 0; i < bytes.length; i++) {
      chars[i] = (char) bytes[i];
    }

    return new String(chars);
  }

  /** Convert a float to a string 
   * @param f The converted object
   * @return A string from float
   */
  public static String floatToString(float f) {
    Float flt = new Float(f);
    long intPart = (long) Math.ceil(f);
    long fewDigits = (long) ((f - intPart) * 1000);

    return "" + intPart + "." + fewDigits;
  }
}
