package javax.safetycritical;

class ScjMissionSequencerProcess extends ScjProcess {

	ScjMissionSequencerProcess(ManagedSchedulable handler, int[] stack) {
		super(handler, stack);
	}
	
	protected void gotoNextState(PriorityFrame pFrame)
	{
		if (state == ScjProcess.State.HANDLED) {
			// missionSequencer terminates
			if (index == -2) {  // outer sequencer
				msObject.cleanUp();
			} else {
				//devices.Console.println("---- ScjMissionSequencerProcess: " + index + ";target: " + target);
				Mission m = Mission.getCurrentMission();
				if (m != null) {
					msObject.cleanUp();
					Mission.getCurrentMission().msSetForMission.removeMSObject(msObject);
				}
			}
			state = ScjProcess.State.TERMINATED;
			return;
		} else {
			state = ScjProcess.State.READY;
			pFrame.readyQueue.insert(this);
		}
	}
}
