package javax.safetycritical;


class ScjManagedThreadProcess extends ScjProcess {

	ScjManagedThreadProcess(ManagedSchedulable handler, int[] stack) {
		super(handler, stack);
	}

	protected void gotoNextState(PriorityFrame pFrame)
	{
		if (state == ScjProcess.State.HANDLED) {
			// thread finished and removed.
			Mission.getCurrentMission().msSetForMission.removeMSObject(msObject);
			state = ScjProcess.State.TERMINATED;
		} 
		else if (state == ScjProcess.State.SLEEPING)
			pFrame.sleepingQueue.insert(this);
		else {
			state = ScjProcess.State.READY;
			pFrame.readyQueue.insert(this);
		}
	}
}
