package javax.safetycritical;


class ScjAperiodicEventHandlerProcess extends ScjProcess {

	ScjAperiodicEventHandlerProcess(ManagedSchedulable handler, int[] stack) {
		super(handler, stack);
	}
	
	protected void gotoNextState(PriorityFrame pFrame)
	{
		if (state == ScjProcess.State.HANDLED) {
			// AperiodicEventHandler finished handling
			if (Mission.getCurrentMission().terminationPending()) {
				Mission.getCurrentMission().msSetForMission
						.removeMSObject(msObject);

				// remove the rest of aperiodic handlers
				Mission.getCurrentMission().msSetForMission
						.removeAperiodicHandlers();

				state = ScjProcess.State.TERMINATED;
			} 
			else {
				// block it and can be released again
				state = ScjProcess.State.BLOCKED;
			}
			return;
		} 
		else {
			state = ScjProcess.State.READY;
			pFrame.readyQueue.insert(this);
		}
	}
}
