package javax.safetycritical.test;

import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.Clock;

import javax.safetycritical.Frame;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.StorageParameters;

import org.jmlspecs.jml4.rac.runtime.JMLAssertionError;

import unitTest.TestCase;

public class TestFrame extends TestCase
{
  class PeriodicEventHandlerStub extends PeriodicEventHandler
  {
    public PeriodicEventHandlerStub(PriorityParameters priotity,
        PeriodicParameters period, StorageParameters storage)
    {
      super(priotity, period,storage);
    }
   
    public void handleAsyncEvent ()
    {
    }
  }
  
  class MissionStub extends Mission
  {
    PeriodicEventHandler pevh;
    
    public MissionStub ()
    {
      initialize ();
    }
    
    protected void initialize ()
    {
      pevh = new PeriodicEventHandlerStub(
              new PriorityParameters(1), 
              new PeriodicParameters(new RelativeTime (), new RelativeTime (2000, 0)),                                
              new StorageParameters (1000L, new long[]{ 100L }, 100L, 200L, 200L));
      pevh.register();
    }

    public long missionMemorySize ()
    {
      return 0;
    }
  }
  
  class MissionSequencerStub extends MissionSequencer<MissionStub>
  {  
    private MissionStub mission; 
    
    public MissionSequencerStub (PriorityParameters priority,
        StorageParameters storage)
    {
      super(priority, storage);
      
      mission = new MissionStub();    
    }
    
    protected MissionStub getNextMission ()
    {
      return mission;
    }  
  }
  
  public void test (int i) 
  {
    StorageParameters storage = 
      new StorageParameters (1000L, new long[]{ 100L }, 100L, 200L, 200L);
    
    PeriodicEventHandler pevh = new PeriodicEventHandlerStub(
        new PriorityParameters(1), 
        new PeriodicParameters(new RelativeTime (), new RelativeTime (2000, 0)),                                
        storage);
    
    MissionSequencerStub seq = 
        new MissionSequencerStub (new PriorityParameters(1), storage);
    
    switch (i) { 
      case  1: // Frame (null, null):
               try{ new Frame(null, null); }
               catch (JMLAssertionError e){}; 
               break;
      case  2: // Frame (null, handlers not null):
               try{ new Frame(null, new PeriodicEventHandler[] {pevh} );}
               catch (JMLAssertionError e){}; 
               break;     
      case  3: // Frame (not null, null):
               try{new Frame(new RelativeTime (1, 1), null);}
               catch (JMLAssertionError e){}; 
               break;
      case  4: // Frame (not null, null):
               try{new Frame(new RelativeTime (1, 1), null);}
               catch (JMLAssertionError e){}; 
               break;
               
      case  5: // Frame (not null, handlers empty):
               new Frame (new RelativeTime (1, 1), 
                          new PeriodicEventHandler[] {});
               break;
      case  6: // Frame (not null, handlers not empty):
               new Frame (new RelativeTime (1, 1), 
               new PeriodicEventHandler[] {seq.getNextMission().pevh});
               break;
      case  7: // Frame (millisecs = 0, handlers not null):
               new Frame (new RelativeTime (0, 1), 
                          new PeriodicEventHandler[] {seq.getNextMission().pevh});
               break;
      case  8: // Frame (nanosecs = 0, handlers not null):
               new Frame (new RelativeTime (1, 0), 
                          new PeriodicEventHandler[] {seq.getNextMission().pevh});
               break;
      case  9: // Frame (millisecs < 0, handlers not null):
               try{ new Frame (new RelativeTime (-1, 0), 
                               new PeriodicEventHandler[] {seq.getNextMission().pevh});}
               catch (JMLAssertionError e){};
               break;
      case 10: // Frame (nanosecs < 0, handlers not null):
               try{ new Frame (new RelativeTime (0, -1), 
                               new PeriodicEventHandler[] {seq.getNextMission().pevh});}
               catch (JMLAssertionError e){};
               break;
      case  11: // Frame (millisecs = 0, nanosecs = 0, handlers not null):
               try{ new Frame (new RelativeTime (0, 0), 
                               new PeriodicEventHandler[] {seq.getNextMission().pevh});}
               catch (JMLAssertionError e){};
               break;
      case  12: // Frame (millisecs < 0, nanosecs < 0, handlers not null):
               try{ new Frame (new RelativeTime (-1, -1), 
                               new PeriodicEventHandler[] {seq.getNextMission().pevh});}
               catch (JMLAssertionError e){};
               break;
     
      default: break;
    }
  }
  
  public static final int testCount = 12;  
}
