package javax.safetycritical.test;

import java.util.Enumeration;

import org.jmlspecs.jml4.rac.runtime.JMLAssertionError;

import unitTest.TestCase;
import unitTest.TestFailure;
import unitTest.TestResult;
import unitTest.TestSuite;

public class AllTests
{
  public static final TestResult result = new TestResult(); 
  
  public static void main (String[] args)
  {
    TestSuite suite = new TestSuite();    

    suite.addTest(test_Frame);
    
    suite.run(result);

    devices.Console.println("Test runs:        " + result.runCount());
    devices.Console.println("Test failures:    " + result.failureCount());
    devices.Console.println("Test errors:      " + result.errorCount());
    devices.Console.println("Test JML errors:  " + result.JMLerrorCount());

    if (result.failureCount() > 0)
    {
      devices.Console.println("\nTest failures are in:");

      for (Enumeration<TestFailure> e = result.failures(); 
          e.hasMoreElements();)
      {
        devices.Console.println("\t" + e.nextElement());
      }
    }
    if (result.errorCount() > 0)
    {
      devices.Console.println("\nTest errors are in:");

      for (Enumeration<TestFailure> e = result.errors(); 
          e.hasMoreElements();)
      {
        devices.Console.println("\t" + e.nextElement());
      }
    }
    if (result.JMLerrorCount() > 0)
    {
      devices.Console.println("\nTest JML errors are in:");

      for (Enumeration<TestFailure> e = result.JMLerrors(); 
          e.hasMoreElements();)
      {
        devices.Console.println("\t" + e.nextElement());
      }
    }
  }
 
  public static TestCase test_Frame = new TestFrame()
  {
    public void runTest ()
    {
      try
      {        
        for (int i = 1; i <= TestFrame.testCount; i++)
          test(i);  
      }
      catch (JMLAssertionError e) { AllTests.result.addJMLError(this, e); }
      catch (Throwable e) { AllTests.result.addError(this, e); }
    }
  };
}
