package javax.realtime.test;

import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.StorageParameters;

//import org.jmlspecs.jml4.rac.runtime.JMLInvariantError;

import unitTest.TestCase;

public class TestReleaseParameters extends TestCase
{ 
  //Test ReleaseParameters
  class ReleaseParametersStub extends ReleaseParameters
  {
    public ReleaseParametersStub ()
    {
      super();
    }

    public ReleaseParametersStub (RelativeTime deadline,
        AperiodicEventHandler missHandler)
    {
      super(deadline, missHandler);
    }
  }
  
  class AperiodicEventHandlerStub extends AperiodicEventHandler
  {
    public AperiodicEventHandlerStub(PriorityParameters priority,
        AperiodicParameters release,
        StorageParameters storage)
    {
      super (priority, release, storage);
    }

    public void handleAsyncEvent ()
    {
    }
  }
  
  public void test (int i) 
  {
    AperiodicEventHandler miss = new AperiodicEventHandlerStub(
        new PriorityParameters(1), new AperiodicParameters(), 
        new StorageParameters (1000L, new long[]{ 100L }, 100L, 200L, 200L) );
      
    switch (i) { 
      case  1: new ReleaseParametersStub(); break;
      case  2: new ReleaseParametersStub(null, null); break;
      case  3: new ReleaseParametersStub(new RelativeTime (0, 0), null);
               break;
      case  4: new ReleaseParametersStub(      
                 new RelativeTime (1, 0),
                 miss);
               break;
               
//      case  5: try {new ReleaseParametersStub(      
//                     new RelativeTime (-1, 0, Clock.getRealtimeClock()),
//                     miss); }
//               catch (JMLInvariantError e){} 
//               break;
//      case  6: try {new ReleaseParametersStub(      
//                      new RelativeTime (0, -1, Clock.getRealtimeClock()),
//                      miss); }
//               catch (JMLInvariantError e){} 
//               break;
      default: break;
    }
  }
  
  public static final int testCount = 6;  
}
