package javax.realtime.test;

import unitTest.TestCase;

import javax.realtime.RelativeTime;
import javax.realtime.Clock;
import javax.realtime.AbsoluteTime;

public class TestRelativeTime extends TestCase 
{
  public TestRelativeTime (String name)
  {
    super(name);
  }
  
  public void test(int i) 
  {
    RelativeTime rel, rel1, rel2;
    AbsoluteTime abs;
    
    switch (i) {
               // Inherited from HighResolutionTime
               // void set(HighResolutionTime time)
      case  1: rel = new RelativeTime(1,1,Clock.getRealtimeClock());            
               try{rel.set(null); assert false;}
               catch (IllegalArgumentException e){}; break;
      case  2: rel = new RelativeTime(); 
               try{rel.set(rel); assert false;}
               catch (ClassCastException e){}; break;
      case  3: rel = new RelativeTime(1,2); 
               rel.set(rel); break;
      case  4: rel = new RelativeTime(1,2); rel1 = new RelativeTime(2,2,null); 
               rel1.set(rel); break;
      case  5: rel = new RelativeTime(1,2); rel2 = new RelativeTime(2,2); 
               rel2.set(rel); break;
               
               // void set (long millis)
      case  6: rel1 = new RelativeTime(2,2); 
               rel1.set(1); break;
      
               // void set (long millis, int nanos)      
      case  7: rel1 = new RelativeTime(1,2); 
               rel1.set(Long.MAX_VALUE,1000001); break;
      case  8: rel1 = new RelativeTime(1,2); 
               rel1.set(Long.MIN_VALUE,-1000001); break;
               
               // boolean equals (HighResolutionTime time)     
      case  9: rel = new RelativeTime(1,2); rel.equals(null); break;
      case 10: rel = new RelativeTime(1,2); rel.equals(this); break;
      case 11: rel = new RelativeTime(1,2); rel.equals(rel); break;
      case 12: rel = new RelativeTime(1,2); rel1 = new RelativeTime(1,3); 
               rel1.equals(rel); break;
               
               // int compareTo (HighResolutionTime time)      
      case 13: try{rel = new RelativeTime(1,2); rel.compareTo(null); assert false;}
               catch (IllegalArgumentException e){}; break;
      case 14: try{rel = new RelativeTime(1,2); abs = new AbsoluteTime(1,2); 
                   rel.compareTo(abs); assert false;}
               catch (ClassCastException e){}; break;
      case 15: try{rel = new RelativeTime(); 
                   new RelativeTime(2,2,null).compareTo(rel);assert false;}
               catch (IllegalArgumentException e){}; break; 
      case 16: new RelativeTime(1,2,null).compareTo(new RelativeTime(2,2,null)); break;
      case 17: new RelativeTime(2,1,null).compareTo(new RelativeTime(2,2,null)); break;
      case 18: new RelativeTime(2,2,null).compareTo(new RelativeTime(2,2,null)); break;
      case 19: new RelativeTime(2,2,null).compareTo(new RelativeTime(1,2,null)); break;
      case 20: new RelativeTime(2,2,null).compareTo(new RelativeTime(2,1,null)); break;
      
               // String toString()    
      case 21: assert new RelativeTime(Long.MAX_VALUE,999999,null).toString()
               == "("+Long.toString(Long.MAX_VALUE)+","+Integer.toString(999999)+")"; break;
    
               // RelativeTime()
      case 31: new RelativeTime(); break;
      
               // RelativeTime(long millis, int nanos)      
      case 32: new RelativeTime(0,0); break;
      case 33: new RelativeTime(0,1000001); break;
      case 34: new RelativeTime(0,-1000001); break;
      case 35: new RelativeTime(-1,1); break;
      case 36: new RelativeTime(1,-1); break;
      case 37: rel = new RelativeTime(Long.MAX_VALUE,1000001); 
               assert rel.getNanoseconds() == -999999; break;
      case 38: rel = new RelativeTime(Long.MIN_VALUE,-1000001); 
               assert rel.getNanoseconds() == 1; break;
               
               // RelativeTime(RelativeTime time)
      case 39: rel = new RelativeTime(); new RelativeTime(rel); break;
      case 40: rel = null; 
               try{ new RelativeTime(rel); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               // RelativeTime (long millis, int nanos, Clock clock)
      case 41: new RelativeTime(0,0,null); break;
      case 42: new RelativeTime(0,1000001,null); break;
      case 43: new RelativeTime(0,-1000001,null); break;
      case 44: new RelativeTime(-1,1,null); break;
      case 45: new RelativeTime(1,-1,null); break;
      case 46: rel = new RelativeTime(Long.MAX_VALUE,1000001,null); 
               assert rel.getNanoseconds() == -999999; break;
      case 47: rel = new RelativeTime(Long.MIN_VALUE,-1000001,null); 
               assert rel.getNanoseconds() == 1; break;         
      case 48: new RelativeTime(1,1,Clock.getRealtimeClock()); break; 
      
               // RelativeTime (Clock clock)
      case 49: Clock c= null; new RelativeTime(c); break;
      case 50: new RelativeTime(Clock.getRealtimeClock()); break;
      
               // RelativeTime add (long millis, int nanos)     
      case 51: rel = new RelativeTime(); rel.add(0,0); break;
      case 52: rel = new RelativeTime(); rel.add(0,1000001); break;
      case 53: rel = new RelativeTime(); rel.add(0,-1000001); break;
      case 54: rel = new RelativeTime(); rel.add(-1,1); break;
      case 55: rel = new RelativeTime(); rel.add(1,-1); break;
      case 56: rel = new RelativeTime(); rel.add(Long.MAX_VALUE,1000001); 
               assert rel.getNanoseconds() == -999999; break;
      case 57: rel = new RelativeTime(); rel.add(Long.MIN_VALUE,-1000001); 
               assert rel.getNanoseconds() == 1; break;  
               
               // RelativeTime add (long millis, int nanos, RelativeTime dest)
      case 58: rel = new RelativeTime(); rel.add(0,0,null); break;
      case 59: rel = new RelativeTime(); rel.add(0,1000001,null); break;
      case 60: rel = new RelativeTime(); rel.add(0,-1000001,null); break;
      case 61: rel = new RelativeTime(); rel.add(-1,1,null); break;
      case 62: rel = new RelativeTime(); rel.add(1,-1,null); break;
      case 63: rel = new RelativeTime(); rel.add(Long.MAX_VALUE,1000001,null); 
               assert rel.getNanoseconds() == -999999; break;
               
      case 64: rel = new RelativeTime(); rel.add(Long.MIN_VALUE,-1000001,null); 
               assert rel.getNanoseconds() == 1; break;        
      case 65: rel1 = new RelativeTime(1,-1); rel = new RelativeTime(); 
               rel.add(0,0,rel1); break;        
      case 66: rel = new RelativeTime(1,-1); rel.add(0,1000001,rel); break;
      case 67: rel = new RelativeTime(1,-1); rel.add(0,-1000001,rel); break;
      
               // RelativeTime add (RelativeTime time)      
      case 68: rel = new RelativeTime(); rel.add(new RelativeTime(1,-1)); break;
      case 69: rel = new RelativeTime();            
               try{rel.add(null); assert false;}
               catch (IllegalArgumentException e){}; break;      
      case 70: rel = new RelativeTime(1,1,Clock.getRealtimeClock());            
               try{rel.add(new RelativeTime(1,1,null)); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               // RelativeTime add (RelativeTime time, RelativeTime dest)
      case 71: rel = new RelativeTime(); 
               rel.add(new RelativeTime(1,-1),null); break;
      case 72: rel = new RelativeTime();            
               try{rel.add(null,null); assert false;}
               catch (IllegalArgumentException e){}; break;     
      case 73: rel = new RelativeTime(1,1,Clock.getRealtimeClock());            
               try{rel.add(new RelativeTime(1,1,null),null); assert false;}
               catch (IllegalArgumentException e){}; break;                
      case 74: rel1 = new RelativeTime(); rel = new RelativeTime(); 
               rel.add(new RelativeTime(1,-1),rel1); break;
      case 75: rel = new RelativeTime(); rel.add(new RelativeTime(1,-1),rel); break;
      
               // RelativeTime subtract (RelativeTime time)
      case 76: rel = new RelativeTime(); rel.subtract(new RelativeTime(1,-1)); break;
      case 77: rel = new RelativeTime();            
               try{rel1 = null; rel.subtract(rel1); assert false;}
               catch (IllegalArgumentException e){}; break;      
      case 78: rel = new RelativeTime(1,1,Clock.getRealtimeClock());            
               try{rel.subtract(new RelativeTime(1,1,null)); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               // RelativeTime subtract (RelativeTime time, RelativeTime dest)
      case 79: rel = new RelativeTime(); 
               rel.subtract(new RelativeTime(1,-1),null); break;
      case 80: rel = new RelativeTime(); 
               rel.subtract(new RelativeTime(1,-1),rel); break;
      case 81: rel = new RelativeTime();            
               try{rel1 = null; rel.subtract(null,rel1); assert false;}
               catch (IllegalArgumentException e){}; break;     
      case 82: rel = new RelativeTime(1,1,Clock.getRealtimeClock());            
               try{rel1 = null; rel.subtract(new RelativeTime(1,1,null),rel1); assert false;}
               catch (IllegalArgumentException e){}; break;
  
      default: break;
    }
  }
  
  public static final int testCount = 82;
  
}