package javax.realtime.test;

import javax.realtime.AperiodicParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.StorageParameters;

import org.jmlspecs.jml4.rac.runtime.JMLInvariantError;

import unitTest.TestCase;

public class TestPeriodicParameters extends TestCase
{
  class AperiodicEventHandlerStub extends AperiodicEventHandler
  {
    public AperiodicEventHandlerStub(PriorityParameters priority,
        AperiodicParameters release,
        StorageParameters storage)
    {
      super (priority, release, storage);
    }

    public void handleAsyncEvent ()
    {
    }
  }
  
  public void test (int i) 
  {
    RelativeTime time_0 = new RelativeTime (0, 0);    
    RelativeTime time_1 = new RelativeTime (1, 0);
    RelativeTime time_2 = new RelativeTime (2, 0);
    
    AperiodicEventHandler miss = new AperiodicEventHandlerStub(
      new PriorityParameters(1), new AperiodicParameters(), 
      new StorageParameters (1000L, new long[]{ 100L }, 100L, 200L, 200L) );
    
    switch (i) {  
               // PeriodicParameters(RelativeTime start, RelativeTime period):
      case  1: try {new PeriodicParameters(null, null);
                    assert false;}
               catch (IllegalArgumentException e){};
               break;
               
               // start == null
      case  2: new PeriodicParameters(null, time_0);
               break;
      case  3: try {new PeriodicParameters(null, new RelativeTime (-1, 0));
                    assert false;}
               catch (JMLInvariantError e){} 
               break;  
      case  4: try {new PeriodicParameters(null, new RelativeTime (0, -1));
                    assert false;}
               catch (JMLInvariantError e){} 
               break; 
               
               // start != null
      case  5: try {new PeriodicParameters(time_0, null);
                    assert false;}
               catch (IllegalArgumentException e){};
               break;
      case  6: new PeriodicParameters(time_0, time_1);
               break; 
               
               // PeriodicParameters(RelativeTime start, RelativeTime period,
               //                    RelativeTime deadline, AperiodicEventHandler missHandler):
     case  7: try {new PeriodicParameters(null, null, null, null);}
              catch (IllegalArgumentException e){};
              break;
     case  8: new PeriodicParameters(time_0, time_1, null, null);
              break;        
     case  9: new PeriodicParameters(time_0, time_2, time_1, null);
              break;
//     case 10: new PeriodicParameters(time_0, time_2, time_1, miss);
//              break; 
      
              //inherited from superclass
     case 11: try {new PeriodicParameters(null, new RelativeTime (-1, 0), 
                     new RelativeTime (-1, 0), miss); 
                   assert false;}
              catch (JMLInvariantError e){} 
              break;
     case 12: try {new PeriodicParameters(null, new RelativeTime (0, -1),   
                     new RelativeTime (-1, 0), miss); 
              assert false; }
              catch (JMLInvariantError e){} 
              break;
      default: break;
    }
  }
  
  public static final int testCount = 12;  
}
