package javax.realtime.test;

import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.StorageParameters;

import org.jmlspecs.jml4.rac.runtime.JMLInvariantError;

import unitTest.TestCase;

public class TestAperiodicParameters extends TestCase
{
  class AperiodicEventHandlerStub extends AperiodicEventHandler
  {
    public AperiodicEventHandlerStub(PriorityParameters priority,
        AperiodicParameters release,
        StorageParameters storage)
    {
      super (priority, release, storage);
    }

    public void handleAsyncEvent ()
    {
    }
  }
  
  public void test (int i) 
  {
    RelativeTime time_1 = new RelativeTime (1, 0);
    
    AperiodicEventHandler miss = new AperiodicEventHandlerStub(
        new PriorityParameters(1), new AperiodicParameters(), 
        new StorageParameters (1000L, new long[]{ 100L }, 100L, 200L, 200L) );
    
    switch (i) {  
               // AperiodicParameters():
      case  1: new AperiodicParameters();
               break;
               
               // public AperiodicParameters(RelativeTime deadline, AperiodicEventHandler missHandler):
      case  2: new AperiodicParameters(null, null);
               break;
      case  3: new AperiodicParameters(null, miss);
               break;  
      case  4: new AperiodicParameters(time_1, null);
               break; 
      case  5: new AperiodicParameters(time_1, miss);
               break;
               
               // inherited from ReleaseParameters
      case  6: try {new AperiodicParameters(new RelativeTime (-1, 0), miss);
                    assert false;}
               catch (JMLInvariantError e){} 
               break;
      case  7: try {new AperiodicParameters(new RelativeTime (0, -1), miss);
                    assert false;}
               catch (JMLInvariantError e){} 
               break;       
      default: break;
    }
  }
  
  public static final int testCount = 7;  
}
