package javax.realtime.test;

import unitTest.TestCase;

import jml.test.apr.Account;
import jml.test.apr.IAccount;
import jml.test.apr.AAccount;

import org.jmlspecs.jml4.rac.runtime.JMLPreconditionError;

public class TestAccount extends TestCase 
{
  //Test IAccount
  class IAccountStub implements IAccount 
  {
    public int balance() {
      return 0;
    }  
  }

  //Test AAccount
  class AAccountStub extends AAccount 
  {
    AAccountStub() {
        bal = 10;
    }
    
    public void withdraw(int amt) {
       bal -= amt;
    } 
  }
  
  public void test(int i) { 
		switch (i) {
		  
		  case  1: new IAccountStub().balance(); break;
		  
		  case  2: new AAccountStub().withdraw(-1); break;
		  case  3: try{new AAccountStub().withdraw(-1);}catch (JMLPreconditionError e){}; break;
		  case  4: new AAccountStub().withdraw(1); break;

		  case  5: new Account(0); break;
		  case  6: new Account(100); break;
		  case  7: try{new Account(-1);}catch (JMLPreconditionError e){}; break;
	    
		  case  8: new Account(100).balance(); break;
	    
		  case  9: try{new Account(300).withdraw(0);}catch (IllegalArgumentException e){}; break;
		  case 10: new Account(300).withdraw(1); break;
		  case 11: new Account(300).withdraw(100); break;
		  case 12: new Account(300).withdraw(300); break;
		  case 13: try{new Account(300).withdraw(301);}catch (IllegalArgumentException e){} break;
		  
		  case 14: try{new Account(0).deposit(-1);}catch (JMLPreconditionError e){}; break;
      case 15: try{new Account(0).deposit(0);}catch (JMLPreconditionError e){}; break;
      case 16: new Account(0).deposit(1); break;
		  
		  default: break;
		}
  }
  
  public static final int testCount = 16;  
  
}


  