package javax.realtime.test;

import unitTest.TestCase;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;

public class TestAbsoluteTime extends TestCase 
{ 
  public TestAbsoluteTime(String name)
  {
    super(name);
  }
  
  public void test(int i) 
  {
    AbsoluteTime abs, abs1, abs2;
    RelativeTime rel;
    
    switch (i) {
               //Inherited from HighResolutionTime
               //void set(HighResolutionTime time)
      case  1: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.set(null); assert false;}
               catch (IllegalArgumentException e){}; break;
      case  2: abs = new AbsoluteTime(); 
               try{abs.set(abs); assert false;}
               catch (ClassCastException e){}; break;
      case  3: abs = new AbsoluteTime(1,2); 
               abs.set(abs); break;
      case  4: abs = new AbsoluteTime(1,2); abs1 = new AbsoluteTime(2,2,null); 
               abs1.set(abs); break;
      case  5: abs = new AbsoluteTime(1,2); abs2 = new AbsoluteTime(2,2); 
               abs2.set(abs); break;
               
               // void set (long millis)
      case  6: abs1 = new AbsoluteTime(2,2); 
               abs1.set(1); break;
               
               // void set (long millis, int nanos)      
      case  7: abs1 = new AbsoluteTime(1,2); 
               abs1.set(Long.MAX_VALUE,1000001); break;
      case  8: abs1 = new AbsoluteTime(1,2); 
               abs1.set(Long.MIN_VALUE,-1000001); break;
               
               // boolean equals (HighResolutionTime time)     
      case  9: abs = new AbsoluteTime(1,2); 
               abs.equals(null); break;
      case 10: abs = new AbsoluteTime(1,2); 
               abs.equals(this); break;
      case 11: abs = new AbsoluteTime(1,2); 
               abs.equals(abs); break;
      case 12: abs = new AbsoluteTime(1,2); abs1 = new AbsoluteTime(1,2); 
               abs1.equals(abs); break;
               
               // int compareTo (HighResolutionTime time)      
      case 13: try{abs = new AbsoluteTime(1,2); 
                   abs.compareTo(null); assert false;}
               catch (IllegalArgumentException e){}; break;
      case 14: try{abs = new AbsoluteTime(1,2); rel = new RelativeTime(1,2);
                   abs.compareTo(rel); assert false;}
               catch (ClassCastException e){}; break;
      case 15: try{abs = new AbsoluteTime(); 
                   new AbsoluteTime(2,2,null).compareTo(abs);assert false;}
               catch (IllegalArgumentException e){}; break; 
      case 16: new AbsoluteTime(1,2,null).compareTo(new AbsoluteTime(2,2,null)); 
               break;
      case 17: new AbsoluteTime(2,1,null).compareTo(new AbsoluteTime(2,2,null)); 
               break;
      case 18: new AbsoluteTime(2,2,null).compareTo(new AbsoluteTime(2,2,null)); 
               break;
      case 19: new AbsoluteTime(2,2,null).compareTo(new AbsoluteTime(1,2,null));  
               break;
      case 20: new AbsoluteTime(2,2,null).compareTo(new AbsoluteTime(2,1,null)); 
               break;
               
               // String toString()    
      case 21: assert new AbsoluteTime(Long.MAX_VALUE,999999,null).toString()
               == "("+Long.toString(Long.MAX_VALUE)+","+Integer.toString(999999)+")"; break;
    
               //AbsoluteTime()
      case 31: new AbsoluteTime(); break;
      
               //AbsoluteTime(long millis, int nanos)      
      case 32: new AbsoluteTime(0,0); break;
      case 33: new AbsoluteTime(0,1000001); break;
      case 34: new AbsoluteTime(0,-1000001); break;
      case 35: new AbsoluteTime(-1,1); break;
      case 36: new AbsoluteTime(1,-1); break;
      case 37: abs = new AbsoluteTime(Long.MAX_VALUE,1000001); 
               assert abs.getNanoseconds() == -999999; break;
      case 38: abs = new AbsoluteTime(Long.MIN_VALUE,-1000001); 
               assert abs.getNanoseconds() == 1; break; 
               
               //AbsoluteTime(AbsoluteTime time)
      case 39: abs = new AbsoluteTime(); new AbsoluteTime(abs); break;
      case 40: abs = null; 
               try{ new AbsoluteTime(abs); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               //AbsoluteTime (long millis, int nanos, Clock clock)
      case 41: new AbsoluteTime(0,0,null); break;
      case 42: new AbsoluteTime(0,1000001,null); break;
      case 43: new AbsoluteTime(0,-1000001,null); break;
      case 44: new AbsoluteTime(-1,1,null); break;
      case 45: new AbsoluteTime(1,-1,null); break;
      case 46: abs = new AbsoluteTime(Long.MAX_VALUE,1000001,null); 
               assert abs.getNanoseconds() == -999999; break;
      case 47: abs = new AbsoluteTime(Long.MIN_VALUE,-1000001,null); 
               assert abs.getNanoseconds() == 1; break;         
      case 48: new AbsoluteTime(1,1,Clock.getRealtimeClock()); break; 
      
               //AbsoluteTime (Clock clock)
      case 49: Clock c= null; new AbsoluteTime(c); break;
      case 50: new AbsoluteTime(Clock.getRealtimeClock()); break;
      
               //AbsoluteTime add (long millis, int nanos)     
      case 51: abs = new AbsoluteTime(); abs.add(0,0); break;
      case 52: abs = new AbsoluteTime(); abs.add(0,1000001); break;
      case 53: abs = new AbsoluteTime(); abs.add(0,-1000001); break;
      case 54: abs = new AbsoluteTime(); abs.add(-1,1); break;
      case 55: abs = new AbsoluteTime(); abs.add(1,-1); break;
      case 56: abs = new AbsoluteTime(); abs.add(Long.MAX_VALUE,1000001); 
               assert abs.getNanoseconds() == -999999; break;
      case 57: abs = new AbsoluteTime(); abs.add(Long.MIN_VALUE,-1000001); 
               assert abs.getNanoseconds() == 1; break; 
               
               //AbsoluteTime add (long millis, int nanos, AbsoluteTime dest)
      case 58: abs = new AbsoluteTime(); abs.add(0,0,null); break;
      case 59: abs = new AbsoluteTime(); abs.add(0,1000001,null); break;
      case 60: abs = new AbsoluteTime(); abs.add(0,-1000001,null); break;
      case 61: abs = new AbsoluteTime(); abs.add(-1,1,null); break;
      case 62: abs = new AbsoluteTime(); abs.add(1,-1,null); break;
      case 63: abs = new AbsoluteTime(); abs.add(Long.MAX_VALUE,1000001,null); 
               assert abs.getNanoseconds() == -999999; break;
      case 64: abs = new AbsoluteTime(); abs.add(Long.MIN_VALUE,-1000001,null); 
               assert abs.getNanoseconds() == 1; break;        
      case 65: abs = new AbsoluteTime(); abs1 = new AbsoluteTime(1,-1); 
               abs.add(0,0,abs1); break; 
               
      case 66: abs = new AbsoluteTime(1,-1); abs1 = new AbsoluteTime();
               abs.add(0,1000001,abs1); break;
      case 67: abs = new AbsoluteTime(1,-1); 
               abs.add(0,1000001,abs); break;      
      case 68: abs = new AbsoluteTime(1,-1); 
               abs.add(0,-1000001,abs); break;
      
               //AbsoluteTime add (RelativeTime time)      
      case 69: abs = new AbsoluteTime(); abs.add(new RelativeTime(1,-1)); break;
      case 70: abs = new AbsoluteTime();            
               try{abs.add(null); assert false;}
               catch (IllegalArgumentException e){}; break;      
      case 71: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.add(new RelativeTime(1,1,null)); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               //AbsoluteTime add (RelativeTime time, AbsoluteTime dest)
      case 72: abs = new AbsoluteTime(); abs.add(new RelativeTime(1,-1),null); break;
      case 73: abs = new AbsoluteTime();            
               try{abs.add(null,null); assert false;}
               catch (IllegalArgumentException e){}; break;     
      case 74: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.add(new RelativeTime(1,1,null),null); assert false;}
               catch (IllegalArgumentException e){}; break;                
      case 75: abs1 = new AbsoluteTime(); abs = new AbsoluteTime(); 
               abs.add(new RelativeTime(1,-1),abs1); break;
      case 76: abs = new AbsoluteTime(); 
               abs.add(new RelativeTime(1,-1),abs); break;
      
               //RelativeTime subtract (AbsoluteTime time)
      case 77: abs = new AbsoluteTime(); abs.subtract(new RelativeTime(1,-1)); break;
      case 78: abs = new AbsoluteTime();            
               try{rel = null; abs.subtract(rel); assert false;}
               catch (IllegalArgumentException e){}; break;      
      case 79: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.subtract(new RelativeTime(1,1,null)); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               //RelativeTime subtract (AbsoluteTime time, RelativeTime dest)
      case 80: abs = new AbsoluteTime(); 
               abs.subtract(new AbsoluteTime(1,-1),null); break;
      case 81: abs = new AbsoluteTime(); rel = new RelativeTime(); 
               abs.subtract(new AbsoluteTime(1,-1),rel); break;
      case 82: abs = new AbsoluteTime();            
               try{rel = null; abs.subtract(null,rel); assert false;}
               catch (IllegalArgumentException e){}; break;     
      case 83: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{rel = null; abs.subtract(new AbsoluteTime(1,1,null),rel); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               //AbsoluteTime subtract (RelativeTime time)
      case 84: abs = new AbsoluteTime(); 
               abs.subtract(new RelativeTime(1,-1)); break;
      case 85: abs = new AbsoluteTime();            
               try{rel = null; abs.subtract(rel); assert false;}
               catch (IllegalArgumentException e){}; break;      
      case 86: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.subtract(new RelativeTime(1,1,null)); assert false;}
               catch (IllegalArgumentException e){}; break;
               
               //AbsoluteTime subtract (RelativeTime time, AbsoluteTime dest)
      case 87: abs = new AbsoluteTime(); 
               abs.subtract(new RelativeTime(1,-1),null); break;
      case 88: abs = new AbsoluteTime(); abs1 = new AbsoluteTime(); 
               abs.subtract(new RelativeTime(1,-1),abs1); break;
      case 89: abs = new AbsoluteTime(); 
               abs.subtract(new RelativeTime(1,-1),abs); break;
      case 90: abs = new AbsoluteTime();            
               try{abs.subtract(null,abs); assert false;}
               catch (IllegalArgumentException e){}; break;     
      case 91: abs = new AbsoluteTime(1,1,Clock.getRealtimeClock());            
               try{abs.subtract(new RelativeTime(1,1,null),abs); assert false;}
               catch (IllegalArgumentException e){}; break; 
      default: break;
    }
  }
  
  public static final int testCount = 91;
}