package javax.realtime.test;

import java.util.Enumeration;

import org.jmlspecs.jml4.rac.runtime.JMLAssertionError;

import unitTest.TestCase;
import unitTest.TestFailure;
import unitTest.TestResult;
import unitTest.TestSuite;

public class AllTests
{
  public static final TestResult result = new TestResult(); 
  
  public static void main (String[] args)
  {
    TestSuite suite = new TestSuite();    
    
//    suite.addTest(test_Account); 
//    suite.addTest(test_SAccount);    
     
//    suite.addTest(test_Clock);
//    suite.addTest(test_RealtimeClock);
    
    suite.addTest(test_AbsoluteTime);
    suite.addTest(test_RelativeTime);
    
    suite.addTest(test_PriorityParameters);
    
//    suite.addTest(test_ReleaseParameters);
    //suite.addTest(test_PeriodicParameters);
    //suite.addTest(test_AperiodicParameters);
        
    suite.run(result);

    devices.Console.println("Test cases:  " + result.runCount());
    devices.Console.println("Test errors: " + result.errorCount());
    devices.Console.println("JML errors:  " + result.JMLerrorCount());
    
    if (result.errorCount() > 0)
    {
      devices.Console.println("\nTest errors are in:");

      for (Enumeration<TestFailure> e = result.errors(); 
          e.hasMoreElements();)
      {
        devices.Console.println("" + e.nextElement());
      }
    }
    if (result.JMLerrorCount() > 0)
    {
      devices.Console.println("\nJML errors are in:");

      for (Enumeration<TestFailure> e = result.JMLerrors(); 
          e.hasMoreElements();)
      {
        devices.Console.println("" + e.nextElement());
      }
    }
  }
  
//  public static TestCase test_Account = new TestAccount()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestAccount.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i); }
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i); }
//    }
//  };
//  
//  public static TestCase test_SAccount = new TestSAccount()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestSAccount.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i); }
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i); }
//    }
//  };
   
  
//  public static TestCase test_Clock = new TestClock()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestClock.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i); }
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i); }
//    }
//  };
//  
//  public static TestCase test_RealtimeClock = new TestRealtimeClock()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestRealtimeClock.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i); }
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i); }
//    }
//  };
  
  public static TestCase test_AbsoluteTime = new TestAbsoluteTime("AbsoluteTime")
  {
    public void runTest ()
    { 
      int i = 1;
      try
      {        
        for ( ; i <= TestAbsoluteTime.testCount; i++)
          test(i);  
      }
      catch (JMLAssertionError e) { 
        AllTests.result.addJMLError(this, e); 
        this.setCaseNumber(i); }
      catch (Throwable e) { 
        AllTests.result.addError(this, e); 
        this.setCaseNumber(i); }
    }
  };
  
    public static TestCase test_RelativeTime = new TestRelativeTime("RelativeTime")
    {
      public void runTest ()
      { int i = 1;
        try
        {        
          for ( ; i <= TestRelativeTime.testCount; i++)
            test(i);  
        }
        catch (JMLAssertionError e) { 
          AllTests.result.addJMLError(this, e); 
          this.setCaseNumber(i);}
        catch (Throwable e) { 
          AllTests.result.addError(this, e); 
          this.setCaseNumber(i);}
      }
    };
  
  public static TestCase test_PriorityParameters = new TestPriorityParameters("PriorityParameters")
  {
    public void runTest ()
    {
      int i = 1;
      try
      {        
        for ( ; i <= TestPriorityParameters.testCount; i++)
          test(i);  
      }
      catch (JMLAssertionError e) { 
        AllTests.result.addJMLError(this, e); 
        this.setCaseNumber(i);}
      catch (Throwable e) { 
        AllTests.result.addError(this, e); 
        this.setCaseNumber(i);}
    }
  };
  
//  public static TestCase test_ReleaseParameters = new TestReleaseParameters()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestReleaseParameters.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i);}
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i);}
//    }
//  };
//  
//  public static TestCase test_PeriodicParameters = new TestPeriodicParameters()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestPeriodicParameters.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i);}
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i);}
//    }
//  };
//  
//  public static TestCase test_AperiodicParameters = new TestAperiodicParameters()
//  {
//    public void runTest ()
//    {
//      int i = 1;
//      try
//      {        
//        for ( ; i <= TestAperiodicParameters.testCount; i++)
//          test(i);  
//      }
//      catch (JMLAssertionError e) { 
//        AllTests.result.addJMLError(this, e); 
//        this.setCaseNumber(i);}
//      catch (Throwable e) { 
//        AllTests.result.addError(this, e); 
//        this.setCaseNumber(i);}
//    }
//  };

}
