//
// Date init       14.12.2004
//
// Revision date   $Date: 2013/08/20 11:53:55 $
//
// Filename        $Workfile:: sam7s256.c                                    $
//
// Version         $Revision: 1.8 $
//
// Archive         $Archive:: /LMS2006/Sys01/Main/Firmware/Sam7s256/Include/ $
//
// Platform        C
//

//#include  "AT91SAM7S256.h"
#include "stdconst.h"
#include "sam7s256.h"
#include "types.h"

extern void dDisplayInit(void);
extern void dDisplayOn(UBYTE On);
extern UBYTE DisplayUpdate(UWORD Height, UWORD Width, UBYTE *pImage);
extern void DisplayWait(void);
extern UBYTE DisplayWrite(UBYTE Type, UBYTE *pData, UWORD Length);
extern UBYTE DisplayWrite1(UBYTE Type, UBYTE *pData, UWORD Length);
extern int run_vm(void);
static UBYTE data;

/* Notes on how to add a new architecture,
 *
 * In types.h the architecture is required to know about sizes. We add a new section enabled by the define SAM7S256.
 *
 * Add defines to set JAVA_HEAP_SIZE and JAVA_STACK_SIZE e.g.
 *
 * -DJAVA_HEAP_SIZE=8192 -DJAVA_STACK_SIZE=512
 *
 * If you have your own main already (as you most likely will) add the following define as well
 *
 * -DEXCLUDEMAIN
 *
 * Add the following functions somewhere reasonable
 *
 *  void init_compiler_specifics(void);
 *  int32* get_java_stack_base(int16 size);
 *  void mark_error(void);
 *  void mark_success(void);
 *  void init_memory_lock(void);
 *  void lock_memory(void);
 *  void unlock_memory(void);
 *  void initNatives(void);
 *  void sendbyte(unsigned char byte);
 *
 * Then add the following files to the build:
 *
 * icecapvm.c
 * natives_allOS.c
 * methodinterpreter.c
 * allocation_point.c
 * methods.c
 * classes.c
 * gc.c
 * print.c
 *
 */

void sendbyte(unsigned char byte) {
	;
}

void initNatives(void) {
	;
}

void init_memory_lock(void) {
}

void lock_memory(void) {
}

void unlock_memory(void) {
}

void init_compiler_specifics(void) {
	;
}

static uint32 java_stack[JAVA_STACK_SIZE];

int32* get_java_stack_base(int16 size) {
	return (int32*) &java_stack[0];
}

void mark_error(void) {
	unsigned char data = 0xff;
	unsigned char c;

	for (c = 0; c < 8; c++) {
		DisplayWait();
		DisplayWrite(1, &data, 1);
	}
}

void mark_success(void) {
	unsigned char data = 0xaa;
	unsigned char c;

	for (c = 0; c < 8; c++) {
		DisplayWait();
		DisplayWrite(1, &data, 1);
	}
}

void readLongFromIO(int32 address, unsigned short offset, int32* msb, int32* lsb) {
}

int32 readIntFromIO(int32 address, unsigned short offset) {
	int32 *ptr;
    address += offset >> 3;
    ptr = (int32*) (pointer) (address);
    return *ptr;
}

unsigned short readShortFromIO(int32 address, unsigned short offset) {
	return 0;
}

unsigned char readByteFromIO(int32 address, unsigned short offset) {
	return 0;
}

unsigned char readBitFromIO(int32 address, unsigned short offset) {
    return 0;
}

void writeLongToIO(int32 address, unsigned short offset, int32 msb, int32 lsb) {
}

void writeIntToIO(int32 address, unsigned short offset, int32 lsb) {
	int32 *ptr;
    address += offset >> 3;
    ptr = (int32*) (pointer) (address);
    *ptr = lsb;
}

void writeShortToIO(int32 address, unsigned short offset, unsigned short lsb) {
}

void writeByteToIO(int32 address, unsigned short offset, unsigned char lsb) {
}

void writeBitToIO(int32 address, unsigned short offset, unsigned char bit) {
}

void main(void) {
	int i;
	while (TRUE) {
		HARDWAREInit;

		/* mSchedInit(); */

		dDisplayInit();
		dDisplayOn(1);

		DisplayWait();
		DisplayUpdate(0, 0, 0);

		DisplayWait();
		DisplayUpdate(0, 0, 0);

		data = 0xaa;

		DisplayWait();
		DisplayWrite(1, &data, 1);

		run_vm();

		data = 0xff;

		DisplayWait();
		DisplayWrite(1, &data, 1);

		while (1 /*TRUE == mSchedCtrl()*/) {
			OSWatchdogWrite;
		}
		/* mSchedExit(); */

		HARDWAREExit;
	}
}
