/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ConfigChangeListener;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_Class;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;

public class JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater {
    static boolean enumerateCAS = false;

    public static void init(Config conf) {
        JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater.setEnumerateCAS(conf);
        conf.addChangeListener((ConfigChangeListener)new ConfigListener());
    }

    static void setEnumerateCAS(Config conf) {
        enumerateCAS = conf.getBoolean("cg.enumerate_cas", false);
    }

    public static void $init__Ljava_lang_Class_2Ljava_lang_String_2__V(MJIEnv env, int objRef, int tClsObjRef, int fNameRef) {
        String fname;
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, tClsObjRef);
        FieldInfo fi = ci.getInstanceField(fname = env.getStringObject(fNameRef));
        ClassInfo fci = fi.getTypeClassInfo();
        if (!fci.isPrimitive() || !fci.getName().equals("long")) {
            env.throwException("java.lang.RuntimeException", "wrong field type");
        }
        int fidx = fi.getFieldIndex();
        env.setIntField(objRef, "fieldId", fidx);
    }

    public static boolean compareAndSet__Ljava_lang_Object_2JJ__Z(MJIEnv env, int objRef, int tRef, long fExpect, long fUpdate) {
        FieldInfo fi;
        if (enumerateCAS && JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater.createAndSetFieldCG(env, objRef)) {
            return false;
        }
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        long v = ei.getLongField(fi = env.getClassInfo(tRef).getInstanceField(fidx));
        if (v == fExpect) {
            ei.setLongField(fi, fUpdate);
            return true;
        }
        return false;
    }

    private static boolean createAndSetFieldCG(MJIEnv env, int objRef) {
        ThreadInfo ti = env.getThreadInfo();
        if (!ti.isFirstStepInsn()) {
            ElementInfo ei = env.getElementInfo(objRef);
            SystemState ss = env.getSystemState();
            ChoiceGenerator cg = ss.getSchedulerFactory().createSharedFieldAccessCG(ei, ti);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                env.repeatInvocation();
                return true;
            }
        }
        return false;
    }

    public static boolean weakCompareAndSet__Ljava_lang_Object_2JJ__Z(MJIEnv env, int objRef, int tRef, long fExpect, long fUpdate) {
        return JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater.compareAndSet__Ljava_lang_Object_2JJ__Z(env, objRef, tRef, fExpect, fUpdate);
    }

    public static void set__Ljava_lang_Object_2J__(MJIEnv env, int objRef, int tRef, long fNewValue) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        ei.setLongField(fi, fNewValue);
    }

    public static void lazySet__Ljava_lang_Object_2J__(MJIEnv env, int objRef, int tRef, long fNewValue) {
        JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater.set__Ljava_lang_Object_2J__(env, objRef, tRef, fNewValue);
    }

    public static long get__Ljava_lang_Object_2__J(MJIEnv env, int objRef, int tRef) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        return ei.getLongField(fi);
    }

    public static long getAndSet__Ljava_lang_Object_2J__J(MJIEnv env, int objRef, int tRef, long fNewValue) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        long result = ei.getLongField(fi);
        ei.setLongField(fi, fNewValue);
        return result;
    }

    public static long getAndAdd__Ljava_lang_Object_2J__J(MJIEnv env, int objRef, int tRef, long fDelta) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        long result = ei.getLongField(fi);
        ei.setLongField(fi, result + fDelta);
        return result;
    }

    static class ConfigListener
    implements ConfigChangeListener {
        ConfigListener() {
        }

        public void propertyChanged(Config conf, String key, String oldValue, String newValue) {
            if ("cg.enumerate_cas".equals(key)) {
                JPF_java_util_concurrent_atomic_AtomicLongFieldUpdater.setEnumerateCAS(conf);
            }
        }
    }
}

