/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.ConfigChangeListener;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_Class;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;

public class JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater {
    static boolean enumerateCAS = false;

    public static void init(Config conf) {
        JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater.setEnumerateCAS(conf);
        conf.addChangeListener((ConfigChangeListener)new ConfigListener());
    }

    static void setEnumerateCAS(Config conf) {
        enumerateCAS = conf.getBoolean("cg.enumerate_cas", false);
    }

    public static void $init__Ljava_lang_Class_2Ljava_lang_String_2__V(MJIEnv env, int objRef, int tClsObjRef, int fNameRef) {
        String fname;
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, tClsObjRef);
        FieldInfo fi = ci.getInstanceField(fname = env.getStringObject(fNameRef));
        ClassInfo fci = fi.getTypeClassInfo();
        if (!fci.isPrimitive() || !fci.getName().equals("int")) {
            env.throwException("java.lang.RuntimeException", "wrong field type");
        }
        int fidx = fi.getFieldIndex();
        env.setIntField(objRef, "fieldId", fidx);
    }

    public static boolean compareAndSet__Ljava_lang_Object_2II__Z(MJIEnv env, int objRef, int tRef, int fExpect, int fUpdate) {
        FieldInfo fi;
        if (enumerateCAS && JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater.createAndSetFieldCG(env, objRef)) {
            return false;
        }
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        int v = ei.getIntField(fi = env.getClassInfo(tRef).getInstanceField(fidx));
        if (v == fExpect) {
            ei.setIntField(fi, fUpdate);
            return true;
        }
        return false;
    }

    private static boolean createAndSetFieldCG(MJIEnv env, int objRef) {
        ThreadInfo ti = env.getThreadInfo();
        if (!ti.isFirstStepInsn()) {
            ElementInfo ei = env.getElementInfo(objRef);
            SystemState ss = env.getSystemState();
            ChoiceGenerator cg = ss.getSchedulerFactory().createSharedFieldAccessCG(ei, ti);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                env.repeatInvocation();
                return true;
            }
        }
        return false;
    }

    public static boolean weakCompareAndSet__Ljava_lang_Object_2II__Z(MJIEnv env, int objRef, int tRef, int fExpect, int fUpdate) {
        return JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater.compareAndSet__Ljava_lang_Object_2II__Z(env, objRef, tRef, fExpect, fUpdate);
    }

    public static void set__Ljava_lang_Object_2I__(MJIEnv env, int objRef, int tRef, int fNewValue) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        ei.setIntField(fi, fNewValue);
    }

    public static void lazySet__Ljava_lang_Object_2I__(MJIEnv env, int objRef, int tRef, int fNewValue) {
        JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater.set__Ljava_lang_Object_2I__(env, objRef, tRef, fNewValue);
    }

    public static int get__Ljava_lang_Object_2__I(MJIEnv env, int objRef, int tRef) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        return ei.getIntField(fi);
    }

    public static int getAndSet__Ljava_lang_Object_2I__I(MJIEnv env, int objRef, int tRef, int fNewValue) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        int result = ei.getIntField(fi);
        ei.setIntField(fi, fNewValue);
        return result;
    }

    public static int getAndAdd__Ljava_lang_Object_2I__I(MJIEnv env, int objRef, int tRef, int fDelta) {
        int fidx = env.getIntField(objRef, "fieldId");
        ElementInfo ei = env.getElementInfo(tRef);
        FieldInfo fi = env.getClassInfo(tRef).getInstanceField(fidx);
        int result = ei.getIntField(fi);
        ei.setIntField(fi, result + fDelta);
        return result;
    }

    static class ConfigListener
    implements ConfigChangeListener {
        ConfigListener() {
        }

        public void propertyChanged(Config conf, String key, String oldValue, String newValue) {
            if ("cg.enumerate_cas".equals(key)) {
                JPF_java_util_concurrent_atomic_AtomicIntegerFieldUpdater.setEnumerateCAS(conf);
            }
        }
    }
}

