/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AnnotationInfo;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ClinitRequired;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_Class;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.MethodInfoRegistry;
import gov.nasa.jpf.util.RunListener;
import gov.nasa.jpf.util.RunRegistry;

public class JPF_java_lang_reflect_Method {
    static MethodInfoRegistry registry;

    public static void init(Config conf) {
        if (registry == null) {
            registry = new MethodInfoRegistry();
            RunRegistry.getDefaultRegistry().addListener(new RunListener(){

                public void reset(RunRegistry reg) {
                    registry = null;
                }
            });
        }
    }

    static int createMethodObject(MJIEnv env, MethodInfo mi) {
        int regIdx = registry.registerMethodInfo(mi);
        int eidx = env.newObject(ClassInfo.getClassInfo((String)"java.lang.reflect.Method"));
        ElementInfo ei = env.getElementInfo(eidx);
        ei.setIntField("regIdx", regIdx);
        return eidx;
    }

    static MethodInfo getMethodInfo(MJIEnv env, int objRef) {
        return registry.getMethodInfo(env, objRef, "regIdx");
    }

    public static int getName____Ljava_lang_String_2(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, objRef);
        int nameRef = env.getReferenceField(objRef, "name");
        if (nameRef == -1) {
            nameRef = env.newString(mi.getName());
            env.setReferenceField(objRef, "name", nameRef);
        }
        return nameRef;
    }

    public static int getModifiers____I(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, objRef);
        return mi.getModifiers();
    }

    static int getParameterTypes(MJIEnv env, int objRef, MethodInfo mi) {
        ThreadInfo ti = env.getThreadInfo();
        String[] argTypeNames = mi.getArgumentTypeNames();
        int[] ar = new int[argTypeNames.length];
        boolean requiresClinitCalls = false;
        for (int i = 0; i < argTypeNames.length; ++i) {
            ClassInfo ci = ClassInfo.getClassInfo((String)argTypeNames[i]);
            if (!ci.isInitialized() && ci.loadAndInitialize(ti, ti.getPC()) > 0) {
                requiresClinitCalls = true;
            }
            ar[i] = ci.getClassObjectRef();
        }
        if (requiresClinitCalls) {
            env.repeatInvocation();
            return -1;
        }
        int aRef = env.newObjectArray("Ljava/lang/Class;", argTypeNames.length);
        for (int i = 0; i < argTypeNames.length; ++i) {
            env.setReferenceArrayElement(aRef, i, ar[i]);
        }
        return aRef;
    }

    public static int getParameterTypes_____3Ljava_lang_Class_2(MJIEnv env, int objRef) {
        return JPF_java_lang_reflect_Method.getParameterTypes(env, objRef, JPF_java_lang_reflect_Method.getMethodInfo(env, objRef));
    }

    public static int getReturnType____Ljava_lang_Class_2(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, objRef);
        ThreadInfo ti = env.getThreadInfo();
        ClassInfo ci = ClassInfo.getClassInfo((String)mi.getReturnTypeName());
        if (!ci.isInitialized() && ci.loadAndInitialize(ti, ti.getPC()) > 0) {
            env.repeatInvocation();
        }
        return ci.getClassObjectRef();
    }

    public static int getDeclaringClass____Ljava_lang_Class_2(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, objRef);
        ClassInfo ci = mi.getClassInfo();
        return ci.getClassObjectRef();
    }

    static int createBoxedReturnValueObject(MJIEnv env, MethodInfo mi, StackFrame frame) {
        byte rt = mi.getReturnType();
        int ret = -1;
        if (rt == 7) {
            double v = frame.doublePop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Double"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setDoubleField("value", v);
        } else if (rt == 11) {
            long v = frame.longPop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Long"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setLongField("value", v);
        } else if (rt == 8) {
            int v = frame.pop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Byte"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setIntField("value", v);
        } else if (rt == 5) {
            int v = frame.pop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Character"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setIntField("value", v);
        } else if (rt == 9) {
            int v = frame.pop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Short"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setIntField("value", v);
        } else if (rt == 10) {
            int v = frame.pop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Integer"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setIntField("value", v);
        } else if (rt == 4) {
            int v = frame.pop();
            ret = env.newObject(ClassInfo.getClassInfo((String)"java.lang.Boolean"));
            ElementInfo rei = env.getElementInfo(ret);
            rei.setIntField("value", v);
        } else if (mi.isReferenceReturnType()) {
            ret = frame.pop();
        }
        return ret;
    }

    static void pushUnboxedArguments(MJIEnv env, MethodInfo mi, StackFrame frame, int argsRef) {
        byte[] at = mi.getArgumentTypes();
        int nArgs = at.length;
        for (int i = 0; i < nArgs; ++i) {
            int argRef = env.getReferenceArrayElement(argsRef, i);
            if (argRef != -1) {
                ElementInfo aei = env.getElementInfo(argRef);
                ClassInfo aci = aei.getClassInfo();
                if (aci.isBoxClass() && at[i] != 14) {
                    String cname = aci.getName();
                    if (cname.equals("java.lang.Long")) {
                        long l = aei.getLongField("value");
                        frame.longPush(l);
                        continue;
                    }
                    if (cname.equals("java.lang.Double")) {
                        double d = aei.getDoubleField("value");
                        frame.push(Types.hiDouble((double)d), false);
                        frame.push(Types.loDouble((double)d), false);
                        continue;
                    }
                    int v = aei.getIntField("value");
                    frame.push(v, false);
                    continue;
                }
                frame.push(argRef, true);
                continue;
            }
            frame.push(-1, true);
        }
    }

    public static int invoke__Ljava_lang_Object_2_3Ljava_lang_Object_2__Ljava_lang_Object_2(MJIEnv env, int mthRef, int objRef, int argsRef) {
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, mthRef);
        if (!ti.isResumedInstruction(insn)) {
            MethodInfo stub = mi.createReflectionCallStub();
            DirectCallStackFrame frame = new DirectCallStackFrame(stub, insn);
            if (!mi.isStatic()) {
                frame.push(objRef, true);
            }
            JPF_java_lang_reflect_Method.pushUnboxedArguments(env, mi, (StackFrame)frame, argsRef);
            ti.pushFrame((StackFrame)frame);
            env.repeatInvocation();
            return -1;
        }
        return JPF_java_lang_reflect_Method.createBoxedReturnValueObject(env, mi, (StackFrame)ti.getReturnedDirectCall());
    }

    public static int getAnnotation__Ljava_lang_Class_2__Ljava_lang_annotation_Annotation_2(MJIEnv env, int mthRef, int annotationClsRef) {
        ClassInfo aci;
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, mthRef);
        AnnotationInfo ai = mi.getAnnotation((aci = JPF_java_lang_Class.getReferredClassInfo(env, annotationClsRef)).getName());
        if (ai != null) {
            ClassInfo aciProxy = ClassInfo.getAnnotationProxy((ClassInfo)aci);
            aciProxy.loadAndInitialize(env.getThreadInfo());
            try {
                return env.newAnnotationProxy(aciProxy, ai);
            }
            catch (ClinitRequired x) {
                env.handleClinitRequest(x.getRequiredClassInfo());
                return -1;
            }
        }
        return -1;
    }

    public static int getAnnotations_____3Ljava_lang_annotation_Annotation_2(MJIEnv env, int mthRef) {
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, mthRef);
        AnnotationInfo[] ai = mi.getAnnotations();
        try {
            return env.newAnnotationProxies(ai);
        }
        catch (ClinitRequired x) {
            env.handleClinitRequest(x.getRequiredClassInfo());
            return -1;
        }
    }

    public static int toString____Ljava_lang_String_2(MJIEnv env, int objRef) {
        StringBuilder sb = new StringBuilder();
        MethodInfo mi = JPF_java_lang_reflect_Method.getMethodInfo(env, objRef);
        sb.append(mi.getReturnTypeName());
        sb.append(' ');
        sb.append(mi.getName());
        sb.append('(');
        String[] at = mi.getArgumentTypeNames();
        for (int i = 0; i < at.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(at[i]);
        }
        sb.append(')');
        int sref = env.newString(sb.toString());
        return sref;
    }
}

