/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DirectCallStackFrame;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_reflect_Method;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.MethodInfoRegistry;
import gov.nasa.jpf.util.RunListener;
import gov.nasa.jpf.util.RunRegistry;

public class JPF_java_lang_reflect_Constructor {
    static MethodInfoRegistry registry;

    public static void init(Config conf) {
        if (registry == null) {
            registry = new MethodInfoRegistry();
            RunRegistry.getDefaultRegistry().addListener(new RunListener(){

                public void reset(RunRegistry reg) {
                    registry = null;
                }
            });
        }
    }

    static int createConstructorObject(MJIEnv env, MethodInfo mi) {
        int regIdx = registry.registerMethodInfo(mi);
        int eidx = env.newObject(ClassInfo.getClassInfo((String)"java.lang.reflect.Constructor"));
        ElementInfo ei = env.getElementInfo(eidx);
        ei.setIntField("regIdx", regIdx);
        return eidx;
    }

    static MethodInfo getMethodInfo(MJIEnv env, int objRef) {
        return registry.getMethodInfo(env, objRef, "regIdx");
    }

    public static int getName____Ljava_lang_String_2(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Constructor.getMethodInfo(env, objRef);
        int nameRef = env.getReferenceField(objRef, "name");
        if (nameRef == -1) {
            nameRef = env.newString(mi.getName());
            env.setReferenceField(objRef, "name", nameRef);
        }
        return nameRef;
    }

    public static int newInstance___3Ljava_lang_Object_2__Ljava_lang_Object_2(MJIEnv env, int mthRef, int argsRef) {
        Instruction insn;
        ThreadInfo ti = env.getThreadInfo();
        if (!ti.isResumedInstruction(insn = ti.getPC())) {
            MethodInfo mi = JPF_java_lang_reflect_Constructor.getMethodInfo(env, mthRef);
            ClassInfo ci = mi.getClassInfo();
            if (ci.isAbstract()) {
                env.throwException("java.lang.InstantiationException");
                return -1;
            }
            int objRef = env.newObject(ci);
            MethodInfo stub = mi.createDirectCallStub("[reflection]");
            DirectCallStackFrame frame = new DirectCallStackFrame(stub, insn);
            frame.push(objRef, true);
            frame.dup();
            JPF_java_lang_reflect_Method.pushUnboxedArguments(env, mi, (StackFrame)frame, argsRef);
            ti.pushFrame((StackFrame)frame);
            env.repeatInvocation();
            return -1;
        }
        DirectCallStackFrame frame = ti.getReturnedDirectCall();
        return frame.pop();
    }

    public static int getParameterTypes_____3Ljava_lang_Class_2(MJIEnv env, int objRef) {
        return JPF_java_lang_reflect_Method.getParameterTypes(env, objRef, JPF_java_lang_reflect_Constructor.getMethodInfo(env, objRef));
    }

    public static int getModifiers____I(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Constructor.getMethodInfo(env, objRef);
        return mi.getModifiers();
    }

    public static int getDeclaringClass____Ljava_lang_Class_2(MJIEnv env, int objRef) {
        MethodInfo mi = JPF_java_lang_reflect_Constructor.getMethodInfo(env, objRef);
        ClassInfo ci = mi.getClassInfo();
        return ci.getClassObjectRef();
    }

    public static int toString____Ljava_lang_String_2(MJIEnv env, int objRef) {
        StringBuilder sb = new StringBuilder();
        MethodInfo mi = JPF_java_lang_reflect_Constructor.getMethodInfo(env, objRef);
        sb.append(mi.getName());
        sb.append('(');
        String[] at = mi.getArgumentTypeNames();
        for (int i = 0; i < at.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(at[i]);
        }
        sb.append(')');
        int sref = env.newString(sb.toString());
        return sref;
    }
}

