/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JPF_java_lang_Class;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.Types;

public class JPF_java_lang_reflect_Array {
    public static int getLength__Ljava_lang_Object_2__I(MJIEnv env, int clsObjRef, int objRef) {
        return env.getArrayLength(objRef);
    }

    public static int newArray__Ljava_lang_Class_2I__Ljava_lang_Object_2(MJIEnv env, int clsRef, int componentTypeRef, int length) {
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, componentTypeRef);
        String clsName = ci.getName();
        return JPF_java_lang_reflect_Array.createNewArray(env, clsName, length);
    }

    static int createNewArray(MJIEnv env, String clsName, int length) {
        int aRef = -1;
        aRef = "boolean".equals(clsName) ? env.newBooleanArray(length) : ("byte".equals(clsName) ? env.newByteArray(length) : ("char".equals(clsName) ? env.newCharArray(length) : ("short".equals(clsName) ? env.newShortArray(length) : ("int".equals(clsName) ? env.newIntArray(length) : ("long".equals(clsName) ? env.newLongArray(length) : ("float".equals(clsName) ? env.newFloatArray(length) : ("double".equals(clsName) ? env.newDoubleArray(length) : env.newObjectArray(clsName, length))))))));
        return aRef;
    }

    public static int multiNewArray__Ljava_lang_Class_2_3I__Ljava_lang_Object_2(MJIEnv env, int clsRef, int componentTypeRef, int dimArrayRef) {
        int i;
        ClassInfo ci = JPF_java_lang_Class.getReferredClassInfo(env, componentTypeRef);
        String clsName = ci.getName();
        int n = env.getArrayLength(dimArrayRef);
        clsName = Types.getTypeCode((String)clsName, (boolean)true);
        String arrayType = "[";
        for (i = 2; i < n; ++i) {
            arrayType = arrayType + '[';
        }
        arrayType = arrayType + clsName;
        int[] dim = new int[n];
        for (i = 0; i < n; ++i) {
            dim[i] = env.getIntArrayElement(dimArrayRef, i);
        }
        int aRef = JPF_java_lang_reflect_Array.createNewMultiArray(env, arrayType, dim, 0);
        return aRef;
    }

    static int createNewMultiArray(MJIEnv env, String arrayType, int[] dim, int level) {
        int aRef = -1;
        int len = dim[level];
        if (level < dim.length - 1) {
            aRef = env.newObjectArray(arrayType, len);
            for (int i = 0; i < len; ++i) {
                int eRef = JPF_java_lang_reflect_Array.createNewMultiArray(env, arrayType.substring(1), dim, level + 1);
                env.setReferenceArrayElement(aRef, i, eRef);
            }
        } else {
            aRef = JPF_java_lang_reflect_Array.createNewArray(env, arrayType, len);
        }
        return aRef;
    }

    public static int get__Ljava_lang_Object_2I__Ljava_lang_Object_2(MJIEnv env, int clsRef, int aref, int index) {
        String at = env.getArrayType(aref);
        if (at.equals("int")) {
            int vref = env.newObject("java.lang.Integer");
            env.setIntField(vref, "value", env.getIntArrayElement(aref, index));
            return vref;
        }
        if (at.equals("long")) {
            int vref = env.newObject("java.lang.Long");
            env.setLongField(vref, "value", env.getLongArrayElement(aref, index));
            return vref;
        }
        if (at.equals("double")) {
            int vref = env.newObject("java.lang.Double");
            env.setDoubleField(vref, "value", env.getDoubleArrayElement(aref, index));
            return vref;
        }
        if (at.equals("boolean")) {
            int vref = env.newObject("java.lang.Boolean");
            env.setBooleanField(vref, "value", env.getBooleanArrayElement(aref, index));
            return vref;
        }
        if (at.equals("char")) {
            int vref = env.newObject("java.lang.Character");
            env.setCharField(vref, "value", env.getCharArrayElement(aref, index));
            return vref;
        }
        if (at.equals("byte")) {
            int vref = env.newObject("java.lang.Byte");
            env.setByteField(vref, "value", env.getByteArrayElement(aref, index));
            return vref;
        }
        if (at.equals("short")) {
            int vref = env.newObject("java.lang.Short");
            env.setShortField(vref, "value", env.getShortArrayElement(aref, index));
            return vref;
        }
        if (at.equals("float")) {
            int vref = env.newObject("java.lang.Float");
            env.setFloatField(vref, "value", env.getFloatArrayElement(aref, index));
            return vref;
        }
        return env.getReferenceArrayElement(aref, index);
    }

    private static int getIntElem(MJIEnv env, int clsRef, int aref, int index) {
        if (!JPF_java_lang_reflect_Array.check(env, aref, index)) {
            return -1;
        }
        String type = env.getArrayType(aref);
        switch (Types.getBaseType((String)type)) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return env.getIntArrayElement(aref, index);
            }
        }
        env.throwException("java.lang.IllegalArgumentException");
        return -1;
    }

    private static long getLongElem(MJIEnv env, int clsRef, int aref, int index) {
        if (!JPF_java_lang_reflect_Array.check(env, aref, index)) {
            return -1L;
        }
        String type = env.getArrayType(aref);
        switch (Types.getBaseType((String)type)) {
            case 7: 
            case 11: {
                return env.getLongArrayElement(aref, index);
            }
        }
        env.throwException("java.lang.IllegalArgumentException");
        return -1L;
    }

    public static boolean getBoolean__Ljava_lang_Object_2I__Z(MJIEnv env, int clsRef, int aref, int index) {
        return JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index) != 0;
    }

    public static byte getByte__Ljava_lang_Object_2I__B(MJIEnv env, int clsRef, int aref, int index) {
        return (byte)JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index);
    }

    public static char getChar__Ljava_lang_Object_2I__C(MJIEnv env, int clsRef, int aref, int index) {
        return (char)JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index);
    }

    public static short getShort__Ljava_lang_Object_2I__S(MJIEnv env, int clsRef, int aref, int index) {
        return (short)JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index);
    }

    public static int getInt__Ljava_lang_Object_2I__I(MJIEnv env, int clsRef, int aref, int index) {
        return JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index);
    }

    public static long getLong__Ljava_lang_Object_2I__J(MJIEnv env, int clsRef, int aref, int index) {
        return JPF_java_lang_reflect_Array.getLongElem(env, clsRef, aref, index);
    }

    public static float getFloat__Ljava_lang_Object_2I__F(MJIEnv env, int clsRef, int aref, int index) {
        return Types.intToFloat((int)JPF_java_lang_reflect_Array.getIntElem(env, clsRef, aref, index));
    }

    public static double getDouble__Ljava_lang_Object_2I__D(MJIEnv env, int clsRef, int aref, int index) {
        return Types.longToDouble((long)JPF_java_lang_reflect_Array.getLongElem(env, clsRef, aref, index));
    }

    private static boolean check(MJIEnv env, int aref, int index) {
        if (aref == -1) {
            env.throwException("java.lang.NullPointerException", "array argument is null");
            return false;
        }
        if (!env.isArray(aref)) {
            env.throwException("java.lang.IllegalArgumentException", "argument is not an array");
            return false;
        }
        if (index < 0 || index >= env.getArrayLength(aref)) {
            env.throwException("java.lang.IndexOutOfBoundsException", "index " + index + " is out of bounds");
            return false;
        }
        return true;
    }

    private static void setIntField(MJIEnv env, int clsRef, int aref, int index, int val) {
        if (!JPF_java_lang_reflect_Array.check(env, aref, index)) {
            return;
        }
        String type = env.getArrayType(aref);
        switch (Types.getBaseType((String)type)) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                env.setIntArrayElement(aref, index, val);
                return;
            }
        }
        env.throwException("java.lang.IllegalArgumentException");
    }

    private static void setLongField(MJIEnv env, int clsRef, int aref, int index, long val) {
        if (!JPF_java_lang_reflect_Array.check(env, aref, index)) {
            return;
        }
        String type = env.getArrayType(aref);
        switch (Types.getBaseType((String)type)) {
            case 7: 
            case 11: {
                env.setLongArrayElement(aref, index, val);
                return;
            }
        }
        env.throwException("java.lang.IllegalArgumentException");
    }

    public static void setBoolean__Ljava_lang_Object_2IZ__V(MJIEnv env, int clsRef, int aref, int index, boolean val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, val ? 1 : 0);
    }

    public static void setByte__Ljava_lang_Object_2IB__V(MJIEnv env, int clsRef, int aref, int index, byte val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, val);
    }

    public static void setChar__Ljava_lang_Object_2IC__V(MJIEnv env, int clsRef, int aref, int index, char val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, val);
    }

    public static void setShort__Ljava_lang_Object_2IS__V(MJIEnv env, int clsRef, int aref, int index, short val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, val);
    }

    public static void setInt__Ljava_lang_Object_2II__V(MJIEnv env, int clsRef, int aref, int index, int val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, val);
    }

    public static void setLong__Ljava_lang_Object_2IJ__V(MJIEnv env, int clsRef, int aref, int index, long val) {
        JPF_java_lang_reflect_Array.setLongField(env, clsRef, aref, index, val);
    }

    public static void setFloat__Ljava_lang_Object_2IF__V(MJIEnv env, int clsRef, int aref, int index, float val) {
        JPF_java_lang_reflect_Array.setIntField(env, clsRef, aref, index, Types.floatToInt((float)val));
    }

    public static void setDouble__Ljava_lang_Object_2ID__V(MJIEnv env, int clsRef, int aref, int index, double val) {
        JPF_java_lang_reflect_Array.setLongField(env, clsRef, aref, index, Types.doubleToLong((double)val));
    }
}

