/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.RUNSTART;

public class JPF_java_lang_Thread {
    public static boolean isAlive____Z(MJIEnv env, int objref) {
        return JPF_java_lang_Thread.getThreadInfo(env, objref).isAlive();
    }

    public static void setDaemon0__Z__V(MJIEnv env, int objref, boolean isDaemon) {
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        ti.setDaemon(isDaemon);
    }

    public static void setName0__Ljava_lang_String_2__V(MJIEnv env, int objref, int nameRef) {
        if (nameRef == -1) {
            env.throwException("java.lang.IllegalArgumentException");
            return;
        }
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        ti.setName(env.getStringObject(nameRef));
    }

    public static void setPriority0__I__V(MJIEnv env, int objref, int prio) {
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        ti.setPriority(prio);
    }

    public static int countStackFrames____I(MJIEnv env, int objref) {
        return JPF_java_lang_Thread.getThreadInfo(env, objref).countStackFrames();
    }

    public static int currentThread____Ljava_lang_Thread_2(MJIEnv env, int clsObjRef) {
        ThreadInfo ti = env.getThreadInfo();
        return ti.getThreadObjectRef();
    }

    public static boolean holdsLock__Ljava_lang_Object_2__Z(MJIEnv env, int clsObjRef, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        ElementInfo ei = env.getElementInfo(objref);
        return ei.isLockedBy(ti);
    }

    public static void init0__Ljava_lang_ThreadGroup_2Ljava_lang_Runnable_2Ljava_lang_String_2J__V(MJIEnv env, int objref, int rGroup, int rRunnable, int rName, long stackSize) {
        ThreadInfo newThread = JPF_java_lang_Thread.createThreadInfo(env, objref);
        newThread.init(rGroup, rRunnable, rName, stackSize, true);
    }

    public static void interrupt____V(MJIEnv env, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        ChoiceGenerator cg = ss.getChoiceGenerator();
        ThreadInfo interruptedThread = JPF_java_lang_Thread.getThreadInfo(env, objref);
        if (!ti.isFirstStepInsn()) {
            interruptedThread.interrupt();
        } else {
            cg = ss.getSchedulerFactory().createInterruptCG(interruptedThread);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                env.repeatInvocation();
            }
        }
    }

    public static boolean isInterrupted____Z(MJIEnv env, int objref) {
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        return ti.isInterrupted(false);
    }

    public static boolean interrupted____Z(MJIEnv env, int clsObjRef) {
        ThreadInfo ti = env.getThreadInfo();
        return ti.isInterrupted(true);
    }

    public static void start____V(MJIEnv env, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        ChoiceGenerator cg = ss.getChoiceGenerator();
        JVM vm = ti.getVM();
        if (!ti.isFirstStepInsn()) {
            ThreadInfo newThread = JPF_java_lang_Thread.getThreadInfo(env, objref);
            if (newThread.getStatus() != 0) {
                env.throwException("java.lang.IllegalThreadStateException");
                return;
            }
            int target = newThread.getTarget();
            if (target == -1) {
                target = objref;
            }
            newThread.setTarget(target);
            vm.notifyThreadStarted(newThread);
            ElementInfo ei = env.getElementInfo(target);
            ClassInfo ci = ei.getClassInfo();
            MethodInfo run = ci.getMethod("run()V", true);
            StackFrame runFrame = new StackFrame(run, target);
            runFrame.setPC((Instruction)new RUNSTART(run));
            newThread.pushFrame(runFrame);
            if (run.isSynchronized()) {
                if (!ei.canLock(newThread)) {
                    ei.block(newThread);
                } else {
                    ei.registerLockContender(newThread);
                }
            }
            if (!newThread.isBlocked()) {
                newThread.setStatus(1);
            }
            if (newThread.usePor()) {
                env.getDynamicArea().analyzeHeap(false);
            }
            if ((cg = ss.getSchedulerFactory().createThreadStartCG(newThread)) != null) {
                ss.setNextChoiceGenerator(cg);
                env.repeatInvocation();
            }
        }
    }

    public static void yield____V(MJIEnv env, int clsObjRef) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        ChoiceGenerator cg = ss.getChoiceGenerator();
        if (!ti.isFirstStepInsn() && (cg = ss.getSchedulerFactory().createThreadYieldCG(ti)) != null) {
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
        }
    }

    public static void sleep__JI__V(MJIEnv env, int clsObjRef, long millis, int nanos) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        ChoiceGenerator cg = ss.getChoiceGenerator();
        if (!ti.isFirstStepInsn() && (cg = ss.getSchedulerFactory().createThreadSleepCG(ti, millis, nanos)) != null) {
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
        }
    }

    public static long getId____J(MJIEnv env, int objref) {
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        return ti.getIndex();
    }

    public int getState0____I(MJIEnv env, int objref) {
        ThreadInfo ti = JPF_java_lang_Thread.getThreadInfo(env, objref);
        switch (ti.getStatus()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        throw new JPFException("illegal thread state: " + ti.getStatus());
    }

    protected static ThreadInfo createThreadInfo(MJIEnv env, int objref) {
        return ThreadInfo.createThreadInfo((JVM)env.getVM(), (int)objref);
    }

    static ThreadInfo getThreadInfo(MJIEnv env, int objref) {
        return ThreadInfo.getThreadInfo((JVM)env.getVM(), (int)objref);
    }
}

