/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.choice.BreakGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.bcel.util.ClassPath;

public class JPF_java_lang_System {
    static String JAVA_CLASS_PATH = "java.class.path";

    public static void arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II__V(MJIEnv env, int clsObjRef, int srcArrayRef, int srcIdx, int dstArrayRef, int dstIdx, int length) {
        block26: {
            int i;
            int dts;
            if (srcArrayRef == -1 || dstArrayRef == -1) {
                env.throwException("java.lang.NullPointerException");
                return;
            }
            if (!env.isArray(srcArrayRef) || !env.isArray(dstArrayRef)) {
                env.throwException("java.lang.ArrayStoreException");
                return;
            }
            int sts = env.getArrayTypeSize(srcArrayRef);
            if (sts != (dts = env.getArrayTypeSize(dstArrayRef))) {
                env.throwException("java.lang.ArrayStoreException");
                return;
            }
            int sl = env.getArrayLength(srcArrayRef);
            int dl = env.getArrayLength(dstArrayRef);
            if (srcIdx < 0 || srcIdx + length > sl) {
                env.throwException("java.lang.ArrayIndexOutOfBoundsException");
                return;
            }
            if (dstIdx < 0 || dstIdx + length > dl) {
                env.throwException("java.lang.ArrayIndexOutOfBoundsException");
                return;
            }
            ClassInfo srcArrayCi = env.getClassInfo(srcArrayRef);
            ClassInfo dstArrayCi = env.getClassInfo(dstArrayRef);
            if (sts == 1) {
                if (srcArrayRef == dstArrayRef && srcIdx < dstIdx) {
                    for (i = length - 1; i >= 0; --i) {
                        int v = env.getIntArrayElement(srcArrayRef, srcIdx + i);
                        env.setIntArrayElement(dstArrayRef, dstIdx + i, v);
                    }
                } else {
                    boolean isDstReferenceArray = dstArrayCi.isReferenceArray();
                    if (isDstReferenceArray != srcArrayCi.isReferenceArray()) {
                        env.throwException("java.lang.ArrayStoreException");
                    }
                    if (!isDstReferenceArray) {
                        if (srcArrayCi != dstArrayCi) {
                            env.throwException("java.lang.ArrayStoreException");
                        }
                        for (i = 0; i < length; ++i) {
                            int v = env.getIntArrayElement(srcArrayRef, srcIdx + i);
                            env.setIntArrayElement(dstArrayRef, dstIdx + i, v);
                        }
                    } else {
                        ClassInfo dstArrayElementCi = dstArrayCi.getComponentClassInfo();
                        for (i = 0; i < length; ++i) {
                            ClassInfo srcArrayElementCi;
                            int srcArrayElementRef = env.getReferenceArrayElement(srcArrayRef, srcIdx + i);
                            if (srcArrayElementRef != -1 && !(srcArrayElementCi = env.getClassInfo(srcArrayElementRef)).isInstanceOf(dstArrayElementCi)) {
                                env.throwException("java.lang.ArrayStoreException");
                                return;
                            }
                            env.setIntArrayElement(dstArrayRef, dstIdx + i, srcArrayElementRef);
                        }
                    }
                }
            } else if (srcArrayRef == dstArrayRef && srcIdx < dstIdx) {
                for (i = length - 1; i >= 0; --i) {
                    long v = env.getLongArrayElement(srcArrayRef, srcIdx + i);
                    env.setLongArrayElement(dstArrayRef, dstIdx + i, v);
                }
            } else {
                if (srcArrayCi != dstArrayCi) {
                    env.throwException("java.lang.ArrayStoreException");
                }
                for (i = 0; i < length; ++i) {
                    long v = env.getLongArrayElement(srcArrayRef, srcIdx + i);
                    env.setLongArrayElement(dstArrayRef, dstIdx + i, v);
                }
            }
            if (!env.hasAttrs(srcArrayRef)) break block26;
            if (srcArrayRef == dstArrayRef && srcIdx < dstIdx) {
                for (i = length - 1; i >= 0; --i) {
                    Object a = env.getElementAttr(srcArrayRef, srcIdx + i);
                    env.setElementAttr(dstArrayRef, dstIdx + i, a);
                }
            } else {
                for (i = 0; i < length; ++i) {
                    Object a = env.getElementAttr(srcArrayRef, srcIdx + i);
                    env.setElementAttr(dstArrayRef, dstIdx + i, a);
                }
            }
        }
    }

    public static int getenv__Ljava_lang_String_2__Ljava_lang_String_2(MJIEnv env, int clsObjRef, int keyRef) {
        String k = env.getStringObject(keyRef);
        String v = System.getenv(k);
        if (v == null) {
            return -1;
        }
        return env.newString(v);
    }

    static int createPrintStream(MJIEnv env, int clsObjRef) {
        ClassInfo ci;
        ThreadInfo ti = env.getThreadInfo();
        Instruction insn = ti.getPC();
        if (insn.requiresClinitCalls(ti, ci = ClassInfo.getClassInfo((String)"gov.nasa.jpf.ConsoleOutputStream"))) {
            env.repeatInvocation();
            return -1;
        }
        return env.newObject(ci);
    }

    public static int createSystemOut____Ljava_io_PrintStream_2(MJIEnv env, int clsObjRef) {
        return JPF_java_lang_System.createPrintStream(env, clsObjRef);
    }

    public static int createSystemErr____Ljava_io_PrintStream_2(MJIEnv env, int clsObjRef) {
        return JPF_java_lang_System.createPrintStream(env, clsObjRef);
    }

    static int getProperties(MJIEnv env, Properties p) {
        int n = p.size() * 2;
        int aref = env.newObjectArray("Ljava/lang/String;", n);
        int i = 0;
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            env.setReferenceArrayElement(aref, i++, env.newString(e.getKey().toString()));
            env.setReferenceArrayElement(aref, i++, env.newString(e.getValue().toString()));
        }
        return aref;
    }

    static int getHostProperties(MJIEnv env) {
        return JPF_java_lang_System.getProperties(env, System.getProperties());
    }

    static int getJPFProperties(MJIEnv env) {
        Config conf = env.getConfig();
        String cf = conf.getString("vm.system.properties_file");
        if (cf != null) {
            try {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(cf);
                p.load(fis);
                return JPF_java_lang_System.getProperties(env, p);
            }
            catch (IOException iox) {
                return -1;
            }
        }
        return -1;
    }

    static int getSelectedHostProperties(MJIEnv env) {
        Config conf = env.getConfig();
        String[] keys = conf.getStringArray("vm.system.properties");
        if (keys == null) {
            String[] defKeys = new String[]{"path.separator", "line.separator", "file.separator", "user.name", "user.dir", "user.timezone", "user.country", "java.home", "java.version", JAVA_CLASS_PATH};
            keys = defKeys;
        }
        int aref = env.newObjectArray("Ljava/lang/String;", keys.length * 2);
        int i = 0;
        for (String s : keys) {
            String v;
            int idx = s.indexOf(47);
            if (idx > 0) {
                v = s.substring(idx + 1);
                s = s.substring(0, idx);
            } else if (s == JAVA_CLASS_PATH) {
                ClassPath cp = ClassInfo.getModelClassPath();
                v = cp.toString();
            } else {
                v = System.getProperty(s);
            }
            if (v == null) continue;
            env.setReferenceArrayElement(aref, i++, env.newString(s));
            env.setReferenceArrayElement(aref, i++, env.newString(v));
        }
        return aref;
    }

    public static int getKeyValuePairs_____3Ljava_lang_String_2(MJIEnv env, int clsObjRef) {
        return JPF_java_lang_System.getSelectedHostProperties(env);
    }

    public static long currentTimeMillis____J(MJIEnv env, int clsObjRef) {
        return System.currentTimeMillis();
    }

    public static long nanoTime____J(MJIEnv env, int clsObjRef) {
        return env.getVM().getTime();
    }

    public static void exit__I__V(MJIEnv env, int clsObjRef, int ret) {
        SystemState ss = env.getSystemState();
        ThreadList tl = env.getVM().getThreadList();
        for (int i = 0; i < tl.length(); ++i) {
            ThreadInfo ti = tl.get(i);
            ti.setTerminated();
        }
        ss.setNextChoiceGenerator((ChoiceGenerator)new BreakGenerator(env.getThreadInfo(), true));
    }

    public static void gc____V(MJIEnv env, int clsObjRef) {
        env.getSystemState().activateGC();
    }

    public static int identityHashCode__Ljava_lang_Object_2__I(MJIEnv env, int clsObjRef, int objref) {
        return objref ^ 0xABCD;
    }
}

