/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.MJIEnv;

public class JPF_java_lang_StringBuffer {
    static boolean hasSharedField = false;

    public static void $clinit____V(MJIEnv env, int clsObjRef) {
        ClassInfo ci = env.getClassInfo();
        if (ci.getInstanceField("shared") != null) {
            hasSharedField = true;
        }
    }

    static int appendString(MJIEnv env, int objref, String s) {
        int slen = s.length();
        int aref = env.getReferenceField(objref, "value");
        int alen = env.getArrayLength(aref);
        int count = env.getIntField(objref, "count");
        int n = count + slen;
        if (n < alen) {
            int i = count;
            int j = 0;
            while (i < n) {
                env.setCharArrayElement(aref, i, s.charAt(j));
                ++i;
                ++j;
            }
        } else {
            int i;
            int m = 3 * alen / 2;
            if (m < n) {
                m = n;
            }
            int arefNew = env.newCharArray(m);
            for (i = 0; i < count; ++i) {
                env.setCharArrayElement(arefNew, i, env.getCharArrayElement(aref, i));
            }
            int j = 0;
            while (i < n) {
                env.setCharArrayElement(arefNew, i, s.charAt(j));
                ++i;
                ++j;
            }
            env.setReferenceField(objref, "value", arefNew);
        }
        if (hasSharedField) {
            env.setBooleanField(objref, "shared", false);
        }
        env.setIntField(objref, "count", n);
        return objref;
    }

    public static int append__Ljava_lang_String_2__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, int sref) {
        String s = env.getStringObject(sref);
        if (s == null) {
            s = "null";
        }
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__I__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, int i) {
        String s = Integer.toString(i);
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__F__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, float f) {
        String s = Float.toString(f);
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__D__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, double d) {
        String s = Double.toString(d);
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__J__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, long l) {
        String s = Long.toString(l);
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__Z__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, boolean b) {
        String s = b ? "true" : "false";
        return JPF_java_lang_StringBuffer.appendString(env, objref, s);
    }

    public static int append__C__Ljava_lang_StringBuffer_2(MJIEnv env, int objref, char c) {
        int aref = env.getReferenceField(objref, "value");
        int alen = env.getArrayLength(aref);
        int count = env.getIntField(objref, "count");
        int n = count + 1;
        if (n < alen) {
            env.setCharArrayElement(aref, count, c);
        } else {
            int m = 3 * alen / 2;
            int arefNew = env.newCharArray(m);
            for (int i = 0; i < count; ++i) {
                env.setCharArrayElement(arefNew, i, env.getCharArrayElement(aref, i));
            }
            env.setCharArrayElement(arefNew, count, c);
            env.setReferenceField(objref, "value", arefNew);
        }
        if (hasSharedField) {
            env.setBooleanField(objref, "shared", false);
        }
        env.setIntField(objref, "count", n);
        return objref;
    }
}

