/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;

public class JPF_java_lang_Object {
    public static int getClass____Ljava_lang_Class_2(MJIEnv env, int objref) {
        ClassInfo oci = env.getClassInfo(objref);
        return oci.getClassObjectRef();
    }

    public static int clone____Ljava_lang_Object_2(MJIEnv env, int objref) {
        int newref;
        DynamicArea da = env.getDynamicArea();
        ElementInfo objinfo = da.get(objref);
        ClassInfo ci = objinfo.getClassInfo();
        if (!ci.isInstanceOf("java.lang.Cloneable")) {
            env.throwException("java.lang.CloneNotSupportedException", ci.getName() + " does not implement java.lang.Cloneable.");
            return -1;
        }
        if (ci.isArray()) {
            ClassInfo cci = ci.getComponentClassInfo();
            String componentType = cci.isPrimitive() ? cci.getType() : Types.getTypeCode((String)cci.getName(), (boolean)false);
            newref = da.newArray(componentType, objinfo.arrayLength(), env.getThreadInfo());
        } else {
            newref = da.newObject(ci, env.getThreadInfo());
        }
        ElementInfo newinfo = da.get(newref);
        newinfo.getFields().copyFrom(objinfo.getFields());
        return newref;
    }

    public static int hashCode____I(MJIEnv env, int objref) {
        return objref ^ 0xABCD;
    }

    public static void registerNatives____V(MJIEnv env, int clsObjRef) {
    }

    static void wait0(MJIEnv env, int objref, long timeout) {
        block8: {
            ElementInfo ei;
            SystemState ss;
            ThreadInfo ti;
            block7: {
                ti = env.getThreadInfo();
                ss = env.getSystemState();
                ei = env.getElementInfo(objref);
                if (!ti.isFirstStepInsn()) break block7;
                switch (ti.getStatus()) {
                    case 3: 
                    case 8: {
                        env.lockNotified(objref);
                        if (ti.isInterrupted(true)) {
                            env.throwException("java.lang.InterruptedException");
                        }
                        break block8;
                    }
                    default: {
                        throw new JPFException("invalid thread state: " + ti.getStatus() + " waiting on " + ei);
                    }
                }
            }
            if (ti.isInterrupted(true)) {
                env.throwException("java.lang.InterruptedException");
            } else {
                env.wait(objref, timeout);
                ChoiceGenerator cg = ss.getSchedulerFactory().createWaitCG(ei, ti, timeout);
                assert (cg != null) : "wait of " + ti.getName() + " on: " + ei + " created no choice generator";
                ss.setNextChoiceGenerator(cg);
                env.repeatInvocation();
            }
        }
    }

    public static void wait____V(MJIEnv env, int objref) {
        JPF_java_lang_Object.wait0(env, objref, 0L);
    }

    public static void wait__J__V(MJIEnv env, int objref, long timeout) {
        JPF_java_lang_Object.wait0(env, objref, timeout);
    }

    public static final void notify____V(MJIEnv env, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            ElementInfo ei = env.getElementInfo(objref);
            ChoiceGenerator cg = ss.getSchedulerFactory().createNotifyCG(ei, ti);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                ti.skipInstructionLogging();
                env.repeatInvocation();
                return;
            }
        }
        env.notify(objref);
    }

    public static void notifyAll____V(MJIEnv env, int objref) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            env.notifyAll(objref);
            ElementInfo ei = env.getElementInfo(objref);
            ChoiceGenerator cg = ss.getSchedulerFactory().createNotifyAllCG(ei, ti);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                ti.skipInstructionLogging();
                env.repeatInvocation();
                return;
            }
        }
    }
}

