/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BrokenBarrierException;

public class CyclicBarrier {
    private Runnable action;
    private int parties;
    private int count;
    private boolean isBroken;
    private final Object lock = new Object();

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public CyclicBarrier(int parties, Runnable action) {
        this.parties = parties;
        this.count = parties;
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int await() throws InterruptedException, BrokenBarrierException {
        Object object = this.lock;
        synchronized (object) {
            int arrival = this.parties - this.count;
            if (--this.count == 0) {
                if (this.action != null) {
                    this.action.run();
                }
                this.count = this.parties;
                this.lock.notifyAll();
            } else {
                try {
                    this.lock.wait();
                    if (this.isBroken) {
                        throw new BrokenBarrierException();
                    }
                }
                catch (InterruptedException ix) {
                    if (this.count > 0) {
                        this.isBroken = true;
                        this.lock.notifyAll();
                    }
                    throw ix;
                }
            }
            return arrival;
        }
    }

    public int getParties() {
        return this.parties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.count != this.parties && this.count != 0) {
                this.isBroken = true;
                this.lock.notifyAll();
            } else {
                this.count = this.parties;
                this.isBroken = false;
            }
        }
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberWaiting() {
        Object object = this.lock;
        synchronized (object) {
            return this.parties - this.count;
        }
    }
}

