/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.io.PrintWriter;

public class Throwable {
    int[] snapshot;
    protected Throwable cause;
    protected String detailMessage;
    protected StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String msg) {
        this();
        this.detailMessage = msg;
        this.cause = this;
    }

    public Throwable(String msg, Throwable xCause) {
        this();
        this.detailMessage = msg;
        this.cause = xCause;
    }

    public Throwable(Throwable xCause) {
        this();
        this.cause = xCause;
        if (this.cause != null) {
            this.detailMessage = xCause.toString();
        }
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.detailMessage;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public native Throwable fillInStackTrace();

    private native StackTraceElement[] createStackTrace();

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = this.createStackTrace();
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] st) {
        this.stackTrace = st;
    }

    public synchronized Throwable initCause(Throwable xCause) {
        if (this.cause == this) {
            throw new IllegalArgumentException("self-causation not permitted");
        }
        if (this.cause != this) {
            throw new IllegalStateException("cannot overwrite cause");
        }
        this.cause = xCause;
        return this;
    }

    public native String toString();

    public native void printStackTrace();

    private native String getStackTraceAsString();

    public void printStackTrace(PrintStream ps) {
        String s = this.getStackTraceAsString();
        ps.print(s);
    }

    public void printStackTrace(PrintWriter pw) {
        String s = this.getStackTraceAsString();
        pw.print(s);
    }
}

