/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.nio.ch.Interruptible;

public class Thread
implements Runnable {
    static int threadNum;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    ThreadGroup group;
    Runnable target;
    String name;
    int priority;
    boolean isDaemon;
    Permit permit;
    boolean interrupted;
    ThreadLocal.ThreadLocalMap threadLocals;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    volatile Object parkBlocker;

    public Thread() {
        this.init(this.group, this.target, this.name, 0L);
    }

    public Thread(Runnable target) {
        this.init(this.group, target, this.name, 0L);
    }

    public Thread(Runnable target, String name) {
        this.init(this.group, target, name, 0L);
    }

    public Thread(String name) {
        this.init(this.group, this.target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this.init(group, target, this.name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this.init(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this.init(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, String name) {
        this.init(group, this.target, name, 0L);
    }

    public static int activeCount() {
        return 0;
    }

    public void setContextClassLoader(ClassLoader cl) {
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public synchronized void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        this.setDaemon0(isDaemon);
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public native long getId();

    public StackTraceElement[] getStackTrace() {
        return null;
    }

    public native int getState0();

    public State getState() {
        int i = this.getState0();
        switch (i) {
            case 0: {
                return State.BLOCKED;
            }
            case 1: {
                return State.NEW;
            }
            case 2: {
                return State.RUNNABLE;
            }
            case 3: {
                return State.TERMINATED;
            }
            case 4: {
                return State.TIMED_WAITING;
            }
            case 5: {
                return State.WAITING;
            }
        }
        return null;
    }

    public synchronized void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("thread name can't be null");
        }
        this.name = name;
        this.setName0(name);
    }

    public String getName() {
        return this.name;
    }

    public void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("thread priority out of range");
        }
        this.priority = priority;
        this.setPriority0(priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    public void checkAccess() {
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public void destroy() {
    }

    public static void dumpStack() {
    }

    public static int enumerate(Thread[] tarray) {
        Thread cur = Thread.currentThread();
        return cur.group.enumerate(tarray);
    }

    public static native boolean holdsLock(Object var0);

    public native void interrupt();

    public static native boolean interrupted();

    public native boolean isInterrupted();

    public native boolean isAlive();

    public synchronized void join() throws InterruptedException {
        while (this.isAlive()) {
            this.wait();
        }
    }

    public synchronized void join(long millis) throws InterruptedException {
        while (this.isAlive()) {
            this.wait(millis);
        }
    }

    public synchronized void join(long millis, int nanos) throws InterruptedException {
        while (this.isAlive()) {
            this.wait(millis);
        }
    }

    @Override
    public void run() {
    }

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    public native void start();

    public void stop() {
    }

    public void suspend() {
    }

    public String toString() {
        return "Thread[" + this.name + ',' + this.priority + ',' + this.group.getName() + ']';
    }

    public static native void yield();

    native void setDaemon0(boolean var1);

    native void setName0(String var1);

    native void setPriority0(int var1);

    void init(ThreadGroup group, Runnable target, String name, long stackSize) {
        Thread cur = Thread.currentThread();
        this.group = group == null ? cur.getThreadGroup() : group;
        this.group.add(this);
        this.name = name == null ? "Thread-" + threadNum++ : name;
        this.permit = new Permit();
        this.priority = cur.getPriority();
        this.isDaemon = cur.isDaemon();
        this.target = target;
        this.init0(this.group, target, this.name, stackSize);
    }

    native void init0(ThreadGroup var1, Runnable var2, String var3, long var4);

    private void exit() {
    }

    native void blockedOn(Interruptible var1);

    public static enum State {
        BLOCKED,
        NEW,
        RUNNABLE,
        TERMINATED,
        TIMED_WAITING,
        WAITING;

    }

    static class Permit {
        boolean isTaken = true;

        Permit() {
        }
    }
}

