/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gov.nasa.jpf.JPFException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationType;

public final class Class<T> {
    private static Annotation[] emptyAnnotations;
    private String name;
    private int cref;
    private boolean isPrimitive;
    private Map<String, T> enumConstantDirectory = null;

    public native boolean isArray();

    public native Annotation[] getAnnotations();

    public native <A extends Annotation> A getAnnotation(Class<A> var1);

    public native boolean isAnnotation();

    public native boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public native Class<?> getComponentType();

    public native Field getDeclaredField(String var1) throws NoSuchFieldException, SecurityException;

    public native Field[] getDeclaredFields() throws SecurityException;

    public native Method getDeclaredMethod(String var1, Class<?> ... var2) throws NoSuchMethodException, SecurityException;

    public native Method getMethod(String var1, Class<?> ... var2) throws NoSuchMethodException, SecurityException;

    public native Method[] getDeclaredMethods() throws SecurityException;

    public native Method[] getMethods() throws SecurityException;

    public native Constructor<?>[] getDeclaredConstructors() throws SecurityException;

    public native Constructor<?>[] getConstructors() throws SecurityException;

    public InputStream getResourceAsStream(String name) {
        throw new JPFException("Class.getResourceAsStream() not yet supported");
    }

    public URL getResource(String name) {
        throw new JPFException("Class.getResource() not yet supported");
    }

    public Package getPackage() {
        String pkgName = null;
        int idx = this.name.lastIndexOf(46);
        if (idx >= 0) {
            pkgName = this.name.substring(0, idx);
            Package pkg = new Package(pkgName, "spectitle", "specversion", "specvendor", "impltitle", "implversion", "implvendor", null, this.getClassLoader());
            return pkg;
        }
        return null;
    }

    public native T[] getEnumConstants();

    T[] getEnumConstantsShared() {
        return this.getEnumConstants();
    }

    Map<String, T> enumConstantDirectory() {
        if (this.enumConstantDirectory == null) {
            T[] ae;
            HashMap<String, T> map = new HashMap<String, T>();
            for (T e : ae = this.getEnumConstants()) {
                map.put(((Enum)e).name(), e);
            }
            this.enumConstantDirectory = map;
        }
        return this.enumConstantDirectory;
    }

    public native Constructor<?> getDeclaredConstructor(Class<?> ... var1) throws NoSuchMethodException, SecurityException;

    public native Field getField(String var1) throws NoSuchFieldException, SecurityException;

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInterface();

    public native Constructor<T> getConstructor(Class<?>[] var1) throws NoSuchMethodException;

    public native int getModifiers();

    public native Class<?>[] getInterfaces();

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int idx = this.name.lastIndexOf(46);
        return this.name.substring(idx + 1);
    }

    public static native Class<?> getPrimitiveClass(String var0);

    public static native Class<?> forName(String var0) throws ClassNotFoundException;

    public static Class<?> forName(String clsName, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(clsName);
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public native Class<?> getSuperclass();

    public native T newInstance() throws InstantiationException, IllegalAccessException;

    public String toString() {
        return "class " + this.name;
    }

    public T cast(Object o) {
        if (o != null && !this.isInstance(o)) {
            throw new ClassCastException();
        }
        return (T)o;
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException("" + this + " is not a " + clazz);
    }

    public native boolean desiredAssertionStatus();

    public native ClassLoader getClassLoader();

    native ConstantPool getConstantPool();

    native void setAnnotationType(AnnotationType var1);

    native AnnotationType getAnnotationType();
}

