/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RandomAccessFile {
    private static final int CHUNK_SIZE = 256;
    private File filename;
    private boolean isOpen;
    private boolean isReadOnly;
    private long currentLength;
    private long currentPosition;
    private DataRepresentation data_root = null;

    public RandomAccessFile(File name, String permissions) throws FileNotFoundException {
        this.filename = name;
        this.isOpen = true;
        this.isReadOnly = "r".equals(permissions);
        this.setDataMap();
    }

    public void seek(long posn) throws IOException {
        this.currentPosition = posn;
    }

    public long length() throws IOException {
        return this.currentLength;
    }

    public native void setDataMap();

    public native void writeByte(int var1) throws IOException;

    public native void write(byte[] var1, int var2, int var3) throws IOException;

    public native void setLength(long var1) throws IOException;

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public native byte readByte() throws IOException;

    public void close() throws IOException {
        this.isOpen = false;
    }

    private static final void printList(DataRepresentation node) {
        DataRepresentation cur = node;
        System.out.print("Chunks:");
        while (cur != null) {
            System.out.print(" " + cur.chunk_index);
            cur = cur.next;
        }
        System.out.println();
    }

    private static class DataRepresentation {
        DataRepresentation next;
        long chunk_index;
        int[] data;

        private DataRepresentation() {
        }
    }
}

