/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gov.nasa.jpf.jvm.abstraction.filter.FilterField;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class File {
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    @FilterField
    int id;
    private String filename;

    public File(String filename) {
        this.filename = filename;
    }

    public File(String parent, String child) {
        this.filename = parent + separator + child;
    }

    public File(File parent, String child) {
        this.filename = parent.filename + separator + child;
    }

    public File(URI uri) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        int idx = this.filename.lastIndexOf(separatorChar);
        if (idx >= 0) {
            return this.filename.substring(idx + 1);
        }
        return this.filename;
    }

    public String getParent() {
        int idx = this.filename.lastIndexOf(separatorChar);
        if (idx >= 0) {
            return this.filename.substring(0, idx);
        }
        return null;
    }

    public int compareTo(Object o) {
        return this.compareTo((File)o);
    }

    public int compareTo(File that) {
        return this.filename.compareTo(that.filename);
    }

    public boolean equals(Object o) {
        return this.filename.equals(((File)o).filename);
    }

    public int hashCode() {
        return this.filename.hashCode();
    }

    public String toString() {
        return this.filename;
    }

    int getPrefixLength() {
        return 0;
    }

    public File getParentFile() {
        return null;
    }

    public String getPath() {
        return null;
    }

    public boolean isAbsolute() {
        return false;
    }

    public String getAbsolutePath() {
        return null;
    }

    public File getAbsoluteFile() {
        return null;
    }

    public String getCanonicalPath() throws IOException {
        return null;
    }

    public File getCanonicalFile() throws IOException {
        return null;
    }

    public URL toURL() throws MalformedURLException {
        return null;
    }

    public URI toURI() {
        return null;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean exists() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return -1L;
    }

    public long length() {
        return -1L;
    }

    public boolean createNewFile() throws IOException {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public void deleteOnExit() {
    }

    public String[] list() {
        return null;
    }

    public String[] list(FilenameFilter fnf) {
        return null;
    }

    public File[] listFiles() {
        return null;
    }

    public File[] listFiles(FilenameFilter fnf) {
        return null;
    }

    public File[] listFiles(FileFilter ff) {
        return null;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public boolean renameTo(File f) {
        return false;
    }

    public boolean setLastModified(long t) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public static File[] listRoots() {
        return null;
    }

    public static File createTempFile(String prefix, String suffix, File dir) throws IOException {
        String tmpDir;
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (dir == null) {
            tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = ".";
            }
            if (tmpDir.charAt(tmpDir.length() - 1) != separatorChar) {
                tmpDir = tmpDir + separatorChar;
            }
            if (suffix == null) {
                suffix = ".tmp";
            }
        } else {
            tmpDir = dir.getPath();
        }
        return new File(tmpDir + prefix + suffix);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }
}

