/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.realtime.MemoryArea;

class IdentityArraySet
extends AbstractSet
implements Set,
Cloneable {
    private static final int DEFAULT_CAPACITY = 16;
    int size;
    Object[] data;
    private int modCount = 0;
    private MemoryArea thisArea = MemoryArea.getMemoryArea(this);

    public IdentityArraySet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative capacity");
        }
        this.data = new Object[n];
    }

    public IdentityArraySet() {
        this(16);
    }

    public IdentityArraySet(Collection collection) {
        this((int)((float)collection.size() * 1.1f));
        this.addAll(collection);
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            try {
                Object[] objectArray = (Object[])this.thisArea.newArray(Object.class, Math.max(n2 * 2, n));
                System.arraycopy(this.data, 0, objectArray, 0, this.size);
                this.data = objectArray;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException.toString());
            }
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.data[i]) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        IdentityArraySet identityArraySet = null;
        try {
            identityArraySet = (IdentityArraySet)super.clone();
            identityArraySet.data = (Object[])this.data.clone();
            identityArraySet.thisArea = MemoryArea.getMemoryArea(identityArraySet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        return identityArraySet;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("null elements not allowed");
        }
        if (this.contains(object)) {
            return false;
        }
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = object;
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            n += this.data[i].hashCode();
        }
        return n;
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != object) continue;
            ++this.modCount;
            this.data[i] = this.data[this.size - 1];
            this.data[--this.size] = null;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size, null);
            this.size = 0;
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;
            private int size = IdentityArraySet.this.size();
            private int knownMod = IdentityArraySet.access$000(IdentityArraySet.this);

            private void checkMod() {
                if (this.knownMod != IdentityArraySet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                this.checkMod();
                return this.pos < this.size;
            }

            public Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                return IdentityArraySet.this.data[this.pos++];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

