/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public abstract class HighResolutionTime
implements Comparable {
    Clock _clock;
    long _milliseconds;
    int _nanoseconds;
    static final boolean CHECK_OVERFLOW = true;
    static final int NANOS_PER_MILLI = 1000000;

    HighResolutionTime(long l, long l2, Clock clock) {
        if (!this.setNormalized(l, l2)) {
            throw new IllegalArgumentException("non-normalizable values");
        }
        this.setClock(clock);
    }

    @SCJRestricted
    @SCJAllowed
    public int compareTo(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("null parameter");
        }
        if (this.getClass() != highResolutionTime.getClass()) {
            throw new ClassCastException();
        }
        if (this._clock != highResolutionTime._clock) {
            throw new IllegalArgumentException("different clocks");
        }
        if (this._milliseconds > highResolutionTime._milliseconds) {
            return 1;
        }
        if (this._milliseconds < highResolutionTime._milliseconds) {
            return -1;
        }
        return this._nanoseconds - highResolutionTime._nanoseconds;
    }

    @SCJAllowed
    @SCJRestricted
    public int compareTo(Object object) {
        return this.compareTo((HighResolutionTime)object);
    }

    @SCJAllowed
    public boolean equals(HighResolutionTime highResolutionTime) {
        return this._nanoseconds == highResolutionTime._nanoseconds && this._milliseconds == highResolutionTime._milliseconds && this._clock == highResolutionTime._clock;
    }

    @SCJAllowed
    public boolean equals(Object object) {
        if (object instanceof HighResolutionTime) {
            return this.equals((HighResolutionTime)object);
        }
        return false;
    }

    @SCJAllowed
    @SCJRestricted
    public Clock getClock() {
        return this._clock;
    }

    @SCJAllowed
    public int hashCode() {
        return (int)(this._milliseconds ^ (long)this._nanoseconds ^ (long)this._clock.hashCode());
    }

    @SCJAllowed
    @SCJRestricted
    public final long getMilliseconds() {
        return this._milliseconds;
    }

    @SCJAllowed
    @SCJRestricted
    public final int getNanoseconds() {
        return this._nanoseconds;
    }

    @SCJAllowed
    @SCJRestricted
    public void set(HighResolutionTime highResolutionTime) {
    }

    @SCJAllowed
    @SCJRestricted
    public void set(long l) {
    }

    @SCJAllowed
    @SCJRestricted
    public void set(long l, int n) {
    }

    @SCJAllowed(value=Level.LEVEL_2)
    @SCJRestricted
    public static void waitForObject(Object object, HighResolutionTime highResolutionTime) throws InterruptedException {
        if (object == null) {
            throw new NullPointerException("null target");
        }
        if (highResolutionTime != null) {
            if (highResolutionTime._clock != Clock.rtc) {
                throw new UnsupportedOperationException("Incompatible clock");
            }
            if (highResolutionTime instanceof AbsoluteTime) {
                highResolutionTime = ((AbsoluteTime)highResolutionTime).subtract(Clock.rtc.getTime());
                object.wait(highResolutionTime.getMilliseconds(), highResolutionTime.getNanoseconds());
            } else {
                if (highResolutionTime.isNegative()) {
                    throw new IllegalArgumentException("negative relative time");
                }
                object.wait(highResolutionTime.getMilliseconds(), highResolutionTime.getNanoseconds());
            }
        } else {
            object.wait();
        }
    }

    public abstract RelativeTime relative(Clock var1);

    final long toNanos() {
        long l = this._milliseconds * 1000000L + (long)this._nanoseconds;
        return l < 0L ? Long.MAX_VALUE : l;
    }

    final boolean isNegative() {
        return this._milliseconds < 0L || this._nanoseconds < 0;
    }

    final boolean isZero() {
        return this._milliseconds == 0L && this._nanoseconds == 0;
    }

    final boolean setNormalized(long l, long l2) {
        long l3 = l2 / 1000000L;
        int n = (int)(l2 % 1000000L);
        if (l > 0L) {
            if (l2 < 0L) {
                this._milliseconds = l + l3;
                if (this._milliseconds > 0L && n != 0) {
                    --this._milliseconds;
                    this._nanoseconds = n + 1000000;
                } else {
                    this._nanoseconds = n;
                }
            } else {
                long l4 = l + l3;
                if (l4 <= 0L) {
                    return false;
                }
                this._milliseconds = l4;
                this._nanoseconds = n;
            }
        } else if (l < 0L) {
            if (l2 < 0L) {
                long l5 = l + l3;
                if (l5 >= 0L) {
                    return false;
                }
                this._milliseconds = l5;
                this._nanoseconds = n;
            } else {
                this._milliseconds = l + l3;
                if (this._milliseconds < 0L && n != 0) {
                    ++this._milliseconds;
                    this._nanoseconds = n - 1000000;
                } else {
                    this._nanoseconds = n;
                }
            }
        } else {
            this._milliseconds = l3;
            this._nanoseconds = n;
        }
        return true;
    }

    final void setClock(Clock clock) {
        this._clock = clock == null ? Clock.rtc : clock;
    }

    final void setDirect(long l, int n) {
        this._milliseconds = l;
        this._nanoseconds = n;
    }

    HighResolutionTime add(long l, int n, HighResolutionTime highResolutionTime) {
        assert (highResolutionTime != null);
        if (!highResolutionTime.setNormalized(HighResolutionTime.addSafe(this._milliseconds, l), (long)this._nanoseconds + (long)n)) {
            throw new ArithmeticException("non-normalizable result");
        }
        highResolutionTime.setClock(this._clock);
        return highResolutionTime;
    }

    static long addSafe(long l, long l2) {
        long l3 = l + l2;
        if (l > 0L && l2 > 0L && l3 <= 0L || l < 0L && l2 < 0L && l3 >= 0L) {
            throw new ArithmeticException("overflow");
        }
        return l3;
    }
}

