/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.SchedulingParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public class AsyncEventHandler
implements Schedulable {
    private final MemoryArea _initMemory;
    private RealtimeThread _handler = null;
    private boolean _noWork = true;
    private boolean _threadStarted = false;
    protected final Object _lock = new Object();
    protected int _fireCount;
    protected final Runnable _logic;
    private SchedulingParameters _scheduling;
    private ReleaseParameters _release;
    private MemoryParameters _memory;
    private ProcessingGroupParameters _group;
    Runnable handlerLogic = new Runnable(){

        public void run() {
            while (!Thread.interrupted()) {
                AsyncEventHandler.this.run();
            }
        }
    };

    public AsyncEventHandler() {
        this(null, null, null, null, null, true, null);
    }

    public AsyncEventHandler(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl, Runnable runnable) {
        this._initMemory = memoryArea;
        this._logic = runnable;
        this._group = processingGroupParameters;
        this._memory = memoryParameters;
        this._release = releaseParameters;
        this._scheduling = schedulingParameters;
    }

    @SCJAllowed
    public ReleaseParameters getReleaseParameters() {
        return this._handler.getReleaseParameters();
    }

    @SCJAllowed
    public SchedulingParameters getSchedulingParameters() {
        return this._handler.getSchedulingParameters();
    }

    public void handleAsyncEvent() {
        if (this._logic != null) {
            this._logic.run();
        }
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public final void run() {
        while (this.getAndDecrementPendingFireCount() > 0) {
            this.handleAsyncEvent();
        }
    }

    void releaseHandler() {
        if (!this._threadStarted) {
            this._handler = new NoHeapRealtimeThread(this._scheduling, this._release, this._memory, this._initMemory, this._group, this.handlerLogic);
            this._threadStarted = true;
            this._handler.start();
        }
        if (this.getAndIncrementPendingFireCount() == 0) {
            this._noWork = false;
        }
    }

    protected MemoryArea getInitMemoryArea() {
        return this._initMemory;
    }

    protected void requestTermination() {
        this._handler.interrupt();
    }

    protected int getAndIncrementPendingFireCount() {
        return this._fireCount++;
    }

    protected int getAndDecrementPendingFireCount() {
        int n = this._fireCount;
        if (this._fireCount > 0) {
            --this._fireCount;
        }
        return n;
    }
}

