/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;

public class ThrowNode
extends Node {
    protected ThrowTree tree;
    protected Node expression;

    public ThrowNode(ThrowTree tree, Node expression, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.expression = expression;
    }

    public Node getExpression() {
        return this.expression;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitThrow(this, p);
    }

    public String toString() {
        return "throw " + this.expression;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ThrowNode)) {
            return false;
        }
        ThrowNode other = (ThrowNode)obj;
        return this.getExpression().equals(other.getExpression());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.expression);
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.expression);
    }
}

