/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.debug;

import checkers.basetype.BaseTypeChecker;
import checkers.basetype.BaseTypeVisitor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.GeneralAnnotatedTypeFactory;
import checkers.types.GenericAnnotatedTypeFactory;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javacutils.TreeUtils;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class TypeOutputtingChecker
extends BaseTypeChecker {
    @Override
    protected BaseTypeVisitor<?> createSourceVisitor() {
        return new Visitor(this);
    }

    public static void main(String[] args) {
        new TypeOutputtingChecker().run(args);
    }

    public void run(String[] args) {
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(new Context());
        Elements elements = env.getElementUtils();
        GeneralAnnotatedTypeFactory atypeFactory = new GeneralAnnotatedTypeFactory(this);
        for (String className : args) {
            TypeElement typeElt = elements.getTypeElement(className);
            TypeOutputtingChecker.printClassType(typeElt, atypeFactory);
        }
    }

    protected static void printClassType(TypeElement typeElt, AnnotatedTypeFactory atypeFactory) {
        assert (typeElt != null);
        String simpleName = typeElt.getSimpleName().toString();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = atypeFactory.fromElement(typeElt);
        System.out.println(simpleName + "\t" + type + "\t" + type.directSuperTypes());
        for (Element element : typeElt.getEnclosedElements()) {
            if (element instanceof TypeElement) {
                TypeOutputtingChecker.printClassType((TypeElement)element, atypeFactory);
            }
            if (!element.getKind().isField() && !(element instanceof ExecutableElement)) continue;
            AnnotatedTypeMirror memberType = atypeFactory.fromElement(element);
            System.out.println(simpleName + "." + element + "\t\t" + memberType);
        }
    }

    public static class Visitor
    extends BaseTypeVisitor<GenericAnnotatedTypeFactory<?, ?, ?, ?>> {
        String currentClass;

        public Visitor(BaseTypeChecker checker) {
            super(checker);
        }

        @Override
        public Void visitClass(ClassTree node, Void p) {
            TypeElement element = TreeUtils.elementFromDeclaration(node);
            this.currentClass = element.getSimpleName().toString();
            AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(node.getSimpleName() + "\t" + type + "\t" + type.directSuperTypes());
            return super.visitClass(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            ExecutableElement elem = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            VariableElement elem = TreeUtils.elementFromDeclaration(node);
            if (elem.getKind().isField()) {
                AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node);
                System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            }
            return null;
        }
    }
}

